function out = thetah(h,params)
% Returns power coefficient theta(h) of marginal utility in liquid
% expenditures (i.e. consumption for home owners, consumption plus apartment
% expenditures for renters).
%
% Input:  
% h:        array. House size, equal to params.h0 for renters.
% params:   structure. Must contain parameters g, xi, h0
%
% Output:   array (same size as h), returning theta(h)

g = params.g;  xi = params.xi;  rentersChoose = params.rentersChoose;  
h0 = params.h0;                     % Read out parameters.

%own = h > 1;         %  Variable for owners: house size not 
                                    % equal to renter size -- leave some 
                                    % room for computational error.
own = abs(h-h0) > 10^(-10);  % !!! MISTAKE        % Variable for owners: house size not 
%                                     % equal to renter size -- leave some 
%                                     % room for computational error.
if rentersChoose                    % If we let renters choose house size:
    out = own*(xi*(g-1)+1) + ~own*g;   
                                    % Curvatature is gamma for renters, and
                                    % takes into account xi for owners.
else                                % If renters can't choose:
    out = ( xi*(g-1) + 1 )*ones(size(h));                                 
end                                 % Same curvature for all.
                                   