function out = tax(y,tauLTC)
% Returns the tax rate from the function estimated by Gouveia & Strauss for
% household income y, plus a tax tauLTC levied to finance some LTC policy
% (set tauLTC=0 to get original GS tax function).
%
% Inputs:
% y:        Array of any size: taxable income.
% tauLTC:   scalar (optional). Tax rate for LTC. Default: 0.

if nargin<2
    tauLTC = 0;
end

out = tauLTC + 0.264*(1-(0.013*(y.^0.964)+1).^(-1/0.964));
                        % Gouveia & Strauss tax function: gives tax rate as
                        % function of taxable income y (in $K). Just add
                        % tauLTC to this.  