function out = phi(tau,taubar)
% Function phi: Approximates heavy-side step function. 
% tau:      Array of any size: Argument that goes into phi.
% taubar:   Scalar that parameterizes phi. Point at which phi reaches 1.

% A: linear spline specification:
out = max( min( tau/taubar, 1), -1 );

% B: inverse specification:
% A specification based on the inverse function 1/x: Cuts half the distance
% from 0 to 1 (i.e. hits 0.5) at taubar. Only works for positive values of
% tau. 
% out = 1 - 1./(tau/taubar+1);

% C: exponential specification:
% A specification based on the exponential function: Works only for
% positive tau. Cuts half the distance from 0 to 1 (i.e. hits 0.5) at taubar.
% out = 1 - exp( -tau*log(2)/taubar );