function p = normpdf(x,mu,sigma)
% Univariate normal probability density function (pdf). NOTE: THIS IS NOT
% THE MATLAB STATS TOOLBOX FUNCTION BUT SELF-BUILT.
%
% Inputs:
% x:                Array of any size.
% mu:               Scalar. Mean of normal distribution. Default: 0.
% sigma:            Scalar. Standard deviation. Default: 1.
% 
% Output:
% Array of same size as x, containing the normal pdf evaluated at each x.

if nargin < 2
    mu = 0;         % Assign standard values if not handed over.
end
if nargin < 3
    sigma = 1;
end                 
p = exp(-0.5 * ((x - mu)./sigma).^2) ./ (sqrt(2*pi) .* sigma);
                    % Calculate normal pdf.
                    