function x = norminv(p,mu,sigma)
% Obtains the inverse of the standard normal pdf (with mean mu and standard
% deviation sigma) of the values p. This is the inverse of the function 
% normpdf.m.
% NOTE: THIS IS NOT THE FUNCTION FROM THE STATS TOOLBOX, BUT A SELF-CREATED
% (SMALLER) VERSION.

% Inputs:
% p:                Array of any size, containing values between 0 and 1.
% mu:               Scalar. Mean of normal distribution. Default: 0.
% sigma:            Scalar. Standard deviation. Default: 1.
% 
% Output:
% Array of same size as p, containing the inverse of the standard normal
% pdf at p. 

if nargin < 2
    mu = 0;                     % Assign standard values if mu and sigma
end                             % are not handed over.
if nargin < 3
    sigma = 1;
end                             % Use inverse of error function.
x = sqrt(2)*sigma.* erfinv(2*p-1)+mu;   