function cdf = normcdf(x, mu, sigma)
% Univariate normal probability cumulative distribution function (cdf).
% NOTE: THIS IS NOT THE MATLAB STATS TOOLBOX FUNCTION BUT SELF-BUILT.
%
% Inputs:
% x:                Array of any size.
% mu:               Scalar. Mean of normal distribution. Default: 0.
% sigma:            Scalar. Standard deviation. Default: 1.
% 
% Output:
% Array of same size as x, containing the cdf evaluated at the x-values.

% Builds on following code:
% file:      	normcdf.m, (c) Matthew Roughan, Tue Jul 21 2009
% directory:   /home/mroughan/src/matlab/NUMERICAL_ROUTINES/
% created: 	Tue Jul 21 2009 
% author:  	Matthew Roughan 
% email:   	matthew.roughan@adelaide.edu.au

if nargin < 2
    mu = 0;                     % Assign standard values if mu and sigma
end                             % are not handed over.
if nargin < 3
    sigma = 1;
    
end                             % Use error function to get output:
cdf = 0.5 * erfc(-(x-mu)/(sigma*sqrt(2)));
