function p = logncdf(x,mu,sigma)
% Univariate log-normal probability density function (pdf) with with
% parameters mu and sigma. 
% NOTE: THIS IS NOT THE MATLAB STATS TOOLBOX FUNCTION BUT SELF-BUILT.
%
% Inputs:
% x:                Array of any size.
% mu:               Scalar. Mean of ln(x). Default: 0.
% sigma:            Scalar. Standard deviation of ln(x). Default: 1.
% 
% Output:
% Array of same size as x, containing the pdf evaluated at each x.

if nargin < 2
    mu = 0;                     % Assign standard values if mu and sigma
end                             % are not handed over.
if nargin < 3
    sigma = 1;
end
x = max(x,0);                   % Set negative values to 0.
z = (log(x)-mu) ./ sigma;       % Get cdf using error function.
p = 0.5 * erfc(-z ./ sqrt(2));
