function dtauSS = dTaxSweden(par,basMArate)
% Obtains increment to pay-roll tax tauSS that is necessary to finance LTC
% coverage for all given MA coverage rate basMArate from the baseline
% economy.
dGen = par.dGen;  HHeffUnits = par.HHeffUnits; dt=par.dt; % Nw = par.Nw;  
ErgDistEps = par.ErgDistEps;

% Have in par.Smod the prob. of being in LTC state given age.
% Set up arrays for stocks and hazards. Dimensions:
% dim.1: age        (Nj points, evenly spaced)
% dim.2: education  (Ne=4 states)
% dim.3: gender     (2 states: page 1 is male, page 2 is female)
SmodFem = par.Smod(:,:,2);      % Row vector par.mapEpsToEduc (1-by-Nw)
                                % tells us to which education group we map
                                % each productivity state. 
SbyProd = SmodFem(:,par.mapEpsToEduc); % (Nj,Nw) array with sick fraction
                                % by age by prod. group.
massSbyProd = dt*ErgDistEps'.*SbyProd; % Multiply by ergodic fractions to 
                                % get mass in each state: (Nj,Nw).
massLTC = sum(massSbyProd(:));  % Integrate over age and sum to get
                                % total mass of LTC cases

expBas = massLTC*basMArate.frac*(par.q + par.Cma);
                                % Expenditure on MA system in U.S. baseline.
expSwe = massLTC*par.q;         % Expenditure on full LTC coverage in Sweden.

tvec = par.tRet-dGen + (dt:dt:dGen)';
                                % Create Nj-by-1 vector with age grid.
grLabIncSwe = par.w*HHeffUnits( tvec, par.epsvec' );
                                % Calculate gross labor income of a kid hh
                                % for all productivity states (dim. 2) and
                                % all ages of kid (dim. 1) when not giving
                                % informal care: Nj-by-Nw matrix.
massKidByProd = ErgDistEps'*dt; % 1-by-Nw vector with mass of kid households
                                % in each cell.
xx = grLabIncSwe.*massKidByProd;% Sum up to get total gross labor income                                
TotGrossLbrIncSwe = sum(xx(:)); % in Sweden.

dtauSS = (expSwe-expBas)/TotGrossLbrIncSwe;
                                % Divide expenditure increase by total
                                % gross labor income to obtain necessary
                                % payroll tax hike. 
                                