function out = TransMatLarge(dimVec,iDim,hazMat)
% Returns the transition matrix on a large vectorized state space of
% dimension dimVec given a transition matrix hazMat for a particular
% dimension iDim of this state space. Transition probabilities are assumed
% to depend only on the state in dimension iDim. The procedure follows 
% the formula 
% out = I(nN) o I(nN-1) o ... o hazMat o ... o I(n2) o I(n1)  , 
% where 'o' denotes the Kronecker product and I(n) is the n-by-n identy
% matrix.
%  
% Input:
% dimVec:    N-by-1 vector with dimensionality of state: [n1, n2, ..., nN]
% iDim:      scalar: integer between 1 and N, gives dimension i to which
%            hazard matrix hazMat belongs.
% hazMat:    ni-by-nitransition hazard matrix for dimension i
%
% Output:
% nSts-by-nSts sparse matrix, where nSts = n1*n2*...*nN. This matrix is the
% transition matrix for the large state space.

nStsBelow = prod( dimVec(1     :iDim-1) ); % total number of states in 
nStsAbove = prod( dimVec(iDim+1:end   ) ); % all dimensions below or above 
                                           % dimension i.
out = kron( speye(nStsAbove),  kron( hazMat, speye(nStsBelow) )  );
                                           % Then create large matrix by 
                                           % concatenating Kronecker 
                                           % products with sparse identity
                                           % matrices
