% Tests how fast a machine writes to memory when going above RAM.

GB=0.5:0.5:4;                       % vector: gigabytes to be stored.
%GB = [5,6,7,8,9,10,12,15,17,20];
n = length(GB);
t  = zeros(1,length(GB));           % vector for time needed

disp('Allocating random-number vectors:')
for i=1:n                           % Allocate random vectors of different
    clear A;                        % size and store how long it takes.
    tic,
    A = rand( round( GB(i)*10^9/8), 1 ); 
    t(i) = toc;
    fprintf('%1.1f GB: %1.2f sec.\n', [GB(i), t(i)]);
end

plot(GB,t,'x-')                     % Make plot of result.
xlabel('GB')
ylabel('seconds')
    