function [SkQ,SpQ] = Surplus(Q,dt,ll,idxIn,ind,par) 
% COPIED THIS FUNCTION AS A NESTED FUNCTION IN GetBargainSolSell AND 
% GetBargainSolIC IN ORDER TO INCREASE COMPUTATIONAL PERFORMANCE. THE
% NESTED FUNCTION HAS ACCESS TO ALL VARIABLES IN THE WORKSPACE.

% Surplus of kid and parent from inside over outside option for a transfer Q.
% Q has to be in range [Qlb,Qub], which implies zero gifts from both sides
% under this Q in the gift-giving stage. 
% 'ind' gives the indeces of states for which the surplus is to
% be calculated.
% Inputs:
% Q:    array of size s.ckUnc(ind) or scalar. 
% dt:   scalar.         Length of time period.
% ll:   STRUCTURE with the following fields for the inside option
%       current loop iteration:
%       cpUnc, ckUnc:   old and young's unconstrained consumption
%       Ucp, Uck:       flow utility under inside option when Q=0.
%       VpOut, VkOut:   parent and kid's value under outside option.
%       Wap, Wak:       value function derivatives of kid
%       gp, gk:         gifts under inside option when Q=0.
%       NetIncPar:      net income of parent under the inside option (with
%                       Q=0)
%       NetIncKid:      net income of young generation under the inside
%                       option (with Q=0).
%       kBr, pBr:       logical. 1 if generation is broke, old and young
%       nnk:            number of persons in kid household
% idxIn:1-by-Nh row vector. Gives housing indices to be considered.
% ind:  indeces for the fields of structure s (logical or other). Have to
%       fulfill  size( s.ckUnc(ind) ) = size(Q)
% par:  STRUCTURE par with fields:
%       alphak: scalar. kid's altruism.
%       eta:    scalar. parent's utility for informal care
%       psy:    scalar. kid's disutility from informal care
%       sh:     scalar. informal-care subsidy
%       nu:     scalar. measure of inframarginal households in kid generation
% 
% Output: two arrays of size of Q or s.ckUnc(ind): 
%       SkQ:            Surplus of kid from inside over outside option
%       SkP:            Surplus of parent.
alphak = par.alphak;  alphap = par.alphap;        % Read out parameters from 'par'
h0   = par.h0;    N      = par.N;      Nw = par.Nw; 
% zeta   = par.zeta;

Nhi        = numel(idxIn);                     % Read out how many housing states we have

VpOut = ll.VpOut(1:N,1:N,1,1:Nw,1:Nw,idxIn);        
VkOut = ll.VkOut(1:N,1:N,1,1:Nw,1:Nw,idxIn);   % Value of outside option
VpIn0 =    ll.Vp(1:N,1:N,1,1:Nw,1:Nw,idxIn);
VkIn0 =    ll.Vk(1:N,1:N,1,1:Nw,1:Nw,idxIn);  % Need value of inside option when Q=0
ek0   =    ll.ek(1:N,1:N,1,1:Nw,1:Nw,idxIn);  % Need consumption under inside option when Q=0 for kid
ep0   =    ll.ep(1:N,1:N,1,1:Nw,1:Nw,idxIn);  % ... and for parent
epUnc = ll.epUnc(1:N,1:N,1,1:Nw,1:Nw,idxIn);  
ekUnc = ll.ekUnc(1:N,1:N,1,1:Nw,1:Nw,idxIn);  
Vak     = ll.Vak(1:N,1:N,1,1:Nw,1:Nw,idxIn);
Vap     = ll.Vap(1:N,1:N,1,1:Nw,1:Nw,idxIn);   
Wak     = ll.Wak(1:N,1:N,1,1:Nw,1:Nw,idxIn);
Wap     = ll.Wap(1:N,1:N,1,1:Nw,1:Nw,idxIn);         

% Need to add zeros to gift arrays when recipient is not broke to have same
% dimensionality:
gk0              = zeros(N,N,1,Nw,Nw,Nhi);      
gk0(:,1,:,:,:,:) = ll.gk(:,1,1,:,:,idxIn);
gp0              = zeros(N,N,1,Nw,Nw,Nhi);
gp0(1,:,:,:,:,:) = ll.gp(1,:,1,:,:,idxIn);
%gk0c   = cat(2, ll.gk(1:N,1  ,1,1:Nw,1:Nw,idxIn), zeros(N  ,N-1,1,Nw,Nw,Nhi) );
%gp0   = cat(1, ll.gp(1  ,1:N,1,1:Nw,1:Nw,idxIn), zeros(N-1,N  ,1,Nw,Nw,Nhi) );
Ucp0  = ll.Ucp(1:N,1:N,1,1:Nw,1:Nw,idxIn);         
Uck0  = ll.Uck(1:N,1:N,1,1:Nw,1:Nw,idxIn);     % Flow felicity 

nnk = ll.nnk;
ek0   = ek0(ind);    ep0   = ep0(ind);
gk0   = gk0(ind);    gp0   = gp0(ind);
Uck0  = Uck0(ind);   Ucp0  = Ucp0(ind);
ekUnc = ekUnc(ind);  epUnc = epUnc(ind);  
Wap   = Wap(ind);    Wak   = Wak(ind);    
Vap   = Vap(ind);    Vak   = Vak(ind);
kBr   = ll.kBr(ind); pBr   = ll.pBr(ind);  

h1         = ll.h(:,:,:,:,:,idxIn).*ones(N,N,1,Nw,Nw,Nhi);       % Bring arrays to full size.
h          = h1(ind);

NetIncPar1 = ll.IncP(1,1:N,1,1,1:Nw,idxIn).*ones(N,N,1,Nw,Nw,Nhi);  
NetIncKid1 = ll.IncK.*ones(N,N,1,Nw,Nw,Nhi);
NetIncPar  = NetIncPar1(ind);   % Bring these to full size
NetIncKid  = NetIncKid1(ind); 

nnpArr1    = ll.nnpArr.*ones(N,N,1,Nw,Nw,Nhi);
nnpArr     = nnpArr1(ind);

% CONSUMPTION UNDER THE INSIDE OPTION WITH Q: NEED TO READ OUT CORRECT INCOME.
% WHEN HEALTHY, WHEN IC, AND WHEN FC. NOTE, Q IS NET TRANSFER FROM PARENT
% TO KID AND INCLUDE GIFTS UNDER THE INSIDE OPTION.
ekQ   = kBr.*min(ekUnc,NetIncKid+Q) + (1-kBr).*ekUnc;
                                    % Young's consumption under informal
                                    % care (note that sh is already in net
                                    % income!).
epQ   = pBr.*min(epUnc,NetIncPar-Q) + (1-pBr).*epUnc; 
                                    % Parent's consumption under informal
                                    % care (note that IC equipment cost is
                                    % already considered in net income)
UckQ = utilde( ekQ, h0, nnk   , par);   
UcpQ = utilde(epQ, h   , nnpArr, par);                                 

duk = UckQ - Uck0; % difference of flow felicity with Q and with Q=0 
dup = UcpQ - Ucp0;
dek = ekQ  - ek0;  % difference of flow expenditures with Q and with Q=0
dep = epQ  - ep0;
dgk = 0    - gk0;  % difference of flow gift with Q and with Q=0
dgp = 0    - gp0;

mukIn = Wap-Wak;
mupIn = Vak-Vap;

dVk  =  (duk + alphak*dup - dek.*Wak - dep.*Wap ...
             +(dgk - dgp - Q).*mukIn  )*dt;
dVp  =  (dup + alphap*duk - dep.*Vap - dek.*Vak ...
             -(dgk - dgp - Q).*mupIn  )*dt;

Sk0 = VkIn0(ind) - VkOut(ind);
Sp0 = VpIn0(ind) - VpOut(ind);
SkQ = Sk0 + dVk;              % Get surplus for kid under Q,    -zeta*Q.^2/2 (don't penalize exchange-motivated transfers when broke for now)
SpQ = Sp0 + dVp; % and for parent.                -zeta*Q.^2/2
