function starFrac = StarFrac(betasq,lambdasq,thetasq)
% For a given hazard matrix with beta~, lambdasq~ and thetasq~, returns the
% fraction of stars under the ergodic distribution.

HazMatSq = [ -lambdasq, lambdasq,         0       ,     0   ; ...
                1     ,    -2   ,         1       ,     0   ; ...
                0     , lambdasq, -lambdasq-thetasq, thetasq; ...
                0     ,  betasq ,         0        , -betasq      ];
pi = PoissonErgodicDist(HazMatSq);
starFrac = pi(4);
