function out = SmoothX(X,par)
% Uses a smoother par.Smoother to smooth the variable X over adjacent
% states. 
% 
% Inputs:
% X:        (N,N,?,...) array with variable to be smoothed.
% par:      STRUCTURE with parameters.
%
% Output:   Array of same size as input X with smoothed variable X.

N = par.N;                      % Read out N from par.
Smoother = MakeSmoother(0.05,0,par); 

siz = size(X);                  % Read out size of input variable X.
nSts = numel(X);                % Number of elements/states.
out = kronm({Smoother,nSts/N^2}, X(:));
                                % Use kronm.m to efficiently compute the 
                                % smoothing only over the subspace of the
                                % first two dimensions. Obtain nSts-by-1
                                % vector.
out = reshape(out,siz);         % Bring back to original size.
