function out = PsiU(p,pbar)
% Gives the weight on Qmax for feasible set of transfer Q (weight on Qmin
% is 1-PsiU).

% Inputs:
% p:        Array of any size. Argument that goes into PsiU, defined as 
%           p = tau_p/(tau_p+tau_k), where tau_i is the iceberg-type
%           transfer motive (percentage of transfer that can be lost for
%           donor to be indifferent to make marginal transfer).
% pbar:     Scalar parameterizing PsiU. PsiU starts to have downward slope
%           at 1-pbar.
%
% Output:   Array of same size as p.

out = min(1, (1-p)/pbar );