function out = PsiL(p,pbar)
% Inputs:
% p:        Array of any size. Argument that goes into PsiL, defined as 
%           p = tau_p/(tau_p+tau_k), where tau_i is the iceberg-type
%           transfer motive (percentage of transfer that can be lost for
%           donor to be indifferent to make marginal transfer).
% pbar:     Scalar parameterizing PsiL. First point p at which Psi_L is 
%           equal to zero.
%
% Output:   Array of same size as p.

out = 1 - min(1, p/pbar );
