%% Figure with counterfactuals relevant for HACC
figure;
% Plot cross-sectional ownership rates by age for various counterfactuals.
load('momBaseline.mat')        % Baseline model 
plot(67:2:93,mom.byAge.ownRate(1:end-1),'-k','LineWidth',2);
legg{1}=sprintf('baseline %1.1f%%',mom.ownRate);
hold on
load('countMom_noKid.mat')     % No child 
plot(67:2:93,countMom.byAge.ownRate(1:end-1),'--k','LineWidth',2);
legg{2}=sprintf('no child %1.1f%%',countMom.ownRate);
load('countMom_omega1.mat')    % No owning premium
plot(67:2:93,countMom.byAge.ownRate(1:end-1),'-ok','LineWidth',1,'MarkerSize',8);
legg{3}=sprintf('no glow %1.1f%%',countMom.ownRate);
load('countMom_noKidOm1.mat')    % No child + no owning premium
plot(67:2:93,countMom.byAge.ownRate(1:end-1),'--ok','LineWidth',1,'MarkerSize',8);
legg{4}=sprintf('no glow + no child %1.1f%%',countMom.ownRate);
ylabel('home ownership rate (parents)')
legend(legg)        % Legend
grid on
ylim([0 1])
xlabel('age')
hold off

%% Figure with counterfactuals relevant for altruism vs. insurance
figure;
% Plot cross-sectional ownership rates by age for various counterfactuals.
load('momBaseline.mat')        % Baseline model 
plot(67:2:93,mom.byAge.ownRate(1:end-1),'-k','LineWidth',2);
legg{1}=sprintf('baseline %1.1f%%',mom.ownRate);
hold on
load('countMom_Sweden.mat')    % Sweden
plot(67:2:93,countMom.byAge.ownRate(1:end-1),'-^k','LineWidth',1,'MarkerSize',8);
legg{2}=sprintf('Sweden %1.1f%%',countMom.ownRate);
load('countMom_noKid.mat')     % No child 
plot(67:2:93,countMom.byAge.ownRate(1:end-1),'--k','LineWidth',2);
legg{3}=sprintf('no child %1.1f%%',countMom.ownRate);
load('countMom_noKidSwed.mat') % No child + Sweden
plot(67:2:93,countMom.byAge.ownRate(1:end-1),'--^k','LineWidth',1,'MarkerSize',8);
legg{4}=sprintf('Sweden + no child %1.1f%%',countMom.ownRate);
ylabel('home ownership rate (parents)')
legend(legg)        % Legend
grid on
ylim([0 1])
xlabel('age')
hold off