function out = NetIncKid(j,ak,eps,h,par)
% Returns net income of a kid household of age j with assets ak,
% productivity eps, and informal-care decision h, net of spending on 
% housing depreciation.
% 
% Inputs: arrays of arbitrary dimension or scalars. Have to be of 
% conformable size if arrays.
% j:    scalar or array of size dim. kid's age.
% ak:   scalar or array of size dim. kid generation's assets
% eps:  scalar or array of size dim. kid's productivity
% h:    logical, scalar or array of size dim. home-care choice.
% par:  structure, containing parameters 
%
% Output: array of size dim.

r          = par.r;           beta   = par.beta; 
tauSS      = par.tauSS;       tauLTC = par.tauLTC;  w  = par.w;   
HHeffUnits = par.HHeffUnits;    % Read out parameters and tax functions.
rent       = par.rent;        rentersChoose = par.rentersChoose; 
TaxCpl     = par.TaxCpl;        % If capital income is taxed.


LabSupply = beta.^h;            % Labor supply:
                                % 1 if h=0 (formal care): entire hh works
                                % beta<1 if h=1 (informal care)
TaxInc = (1-tauSS)*LabSupply.*w*HHeffUnits(j,eps) + TaxCpl.*r*ak;  
                                % Taxable income: labor income of hh net of
                                % social-security contributions, plus asset
                                % income of one kid household (the latter
                                % only if asset income taxed).
if rentersChoose                % If we let renters choose house size, then 
    HouseExp = 0;               % rent is in e4 (expenditures in Stage 4).
else                            % If renters don't choose house size:
    HouseExp = rent;            % Children pay fixed rent.
end                                
                                
out = ( 1 - tax(TaxInc,tauLTC) ) .* TaxInc - HouseExp + (1-TaxCpl).*r*ak;
                                % Return net household income. Have to add
                                % capital income here if not taxed. 
                                
