function out = MAaverage(ProbMA,varMA,varNoMA)
% Takes the average between one variable for the MA scenario (varMA) and
% the no-MA scenario (varNoMA) using the probability of MA (ProbMA).
% 
% Inputs:
% ProbMA:   (N,1,k,Nw,Nw,Nh) array. Probability of MA when parent is broke 
%           in disabled state.
% varMA:    Array conformable with ProbMA. Value that the variable of interest 
%           takes in MA.
% varNoMA:  (N,N,k,Nw,Nw,Nh) array. Value that the variable of interest 
%           takes outside MA (in the disabled state).
%
% Output:   (N,N,k,Nw,Nw,Nh) array. Value of the variable of interest as
%           average over MA and no-MA scenario.

% varOldBroke = ProbMA.*varMA + (1-ProbMA).*varNoMA(:,1,:,:,:,:);
% out = cat(2,varOldBroke,varNoMA(:,2:end,:,:,:,:)); 
                                                % Take average when old 
                                                 % broke, and take just var
% Take varNoMa as default, but set the MA value when parent is broke and
% chooses Medicaid:
out = varNoMA;
out(:,1,:,:,:,:) = ProbMA.*varMA + (1-ProbMA).*varNoMA(:,1,:,:,:,:);
