function dimInd = LinInd2DimInd(LinInd,arrSiz,dim)
% 
% Inputs:
% LinInd:           Vector with linear indeces of a multi-dim. array.
% arrSiz:           1-by-N vector, where N is the number of dimensions of
%                   the multi-dim. array.
% dim:              Scalar (>=1, <=N). Dimension for which the index is to
%                   be returned.
%
% Output:           Vector of same size as LinInd. Contains the index in
%                   dimension 'dim' corresponding to the grid point with
%                   linear index 'LinInd'.

N  = numel(arrSiz);                 % Get number of dimensions
switch dim                          % Special treatment for first and last 
                                    % dimension.
    case 1                          % First: Just take remainder of division
        dimInd = rem( LinInd / prod(arrSiz(2:N)   ) );  % of block size of other
                                                        % dimensions.
    case N                          % Last: Divide by the size of the block
        dimInd = ceil(LinInd / prod(arrSiz(1:N-1) ) );  % dimensions 1 to N-1.
    otherwise                       % Need to mix the two for intermediate dim:
        ii     = rem( LinInd / prod(arrSiz(1:dim) ) );
        dimInd = ceil( ii    / prod(arrSiz(1:dim-1) ) );
end

