function ArrInd = Lin2ArrInd(LinInd,siz)
% For array of size 'siz', turns linear index (read: X(11)) into
% array indexing (read: X(1,2,1)).
%
% Input:
% LinInd:   N-by-1 vector. Linear index of elements of . Index: X(3).
% siz:      1-by-nDim row vector. Size of array with multiple dimensions.
%
% Output:
% ArrInd: N x nDim matrix. Each row describes one element in the nDim-
%         dimensional array. Have N such elements (variable). Index: X(1,2);
%
% Note: Comparable to Matlab function sub2ind, but takes in all indices at
% once and is faster.

nDim = numel(siz);                      % Number of dimensions of array.
ArrInd  = zeros(numel(LinInd),nDim);    % Set up N-by-nDim matrix for the 
                                        % result: array indeces.
xx   = LinInd;                          % Create running variable for loop.

for i=nDim:-1:2                         % Loop down from dimension nDim to 2.
    blockSize = prod( siz(1:i-1) );     % Get size of a 'block' of variables
                                        % below dimension i.
    indi = ceil( xx / blockSize );      % Dividing by this block size and 
    ArrInd(:,i) = indi;                 % going up to next integer gives us
                                        % index in dimension i.
    xx = xx - (indi-1)*blockSize;       % Remove 'blocks' from running variable:
end                                     % xx is <= prod( siz(1:i) ).

ArrInd(:,1) = xx;                       % Last dimension: Have the correct
                                        % one left.
