function out = KKstarInflow(starFrac,starPers,epsHaz1Dreg,ProbHi)
% Obtains the outflow from stardom (ergodic prob. of stars times outflow
% hazard) given the transition matrix that follows from guessing a
% probability ProbHi to be in the highest regular state (which determines
% inflows to stardom). Use this function to obtain ProbHi that gives the
% correct amount of stars

% Inputs:
% starFrac:     Scalar. Ergodic probability of being in the star state.
%               Targeted in our calibration.
% starPers:     Scalar. Hazard rate of leaving star state.
% epsHaz1Dreg:  (Nw-1)-by-(Nw-1) matrix. Hazard rates of switching between
%               the regular states, i.e. states 1 to Nw-1.
% ProbHi:       Scalar. Ergodic probability of being in the highest regular
%               state (state Nw-1). This is guessed.
%
% Output:       Scalar. Inflow into stardom in ergodic distribution.      

starIn = starFrac*starPers/ProbHi;  % Get outflow rate from 2nd-to-last
                                    % grid point (the highest regular
                                    % state) to stardom so that a
                                    % fraction starFrac of people are
                                    % stars in the long run.
epsHaz1D = KKTransMat(epsHaz1Dreg,starIn,starPers);
                                    % Obtain the Nw-by-Nw hazard transition 
                                    % matrix for productivity.
ErgDist = PoissonErgodicDist(epsHaz1D,1000);
                                    % Find ergodic distribution of the
                                    % Poisson process after 1000 years.
out = ErgDist(end-1)*starIn;        % Return the inflow rate that obtains 
                                    % into stardom under the ergodic
                                    % distribution. If the guess ProbHi was
                                    % correct, we get
                                    % ProbHi=ErgDist(end-1), but usually
                                    % they will differ!
                                    