function Vout = InterpSellAln(Vin,aksell,par)
% Interpolates to get house-selling values for alone-economy (old
% children).

% Input:
% Vin:             Given input value function, (N,ns,Nw) array. Child's value
%                  function on ak-grid when alone.
% aksell:          For which child assets we want interpolated/extrapolated
%                  values. 
%                  Selling decision: (N,1,1,Nh) array, varies only in child 
%                                    assets and house size.
%                  Bequest values:   (N,N,Nh) array.
%
% Output:
% Vout:            Interpolated values. 
%                  Selling decision: (N,Ns,Nw,Nh) array.
%                  Bequest values: (N,N,1,Nw,1,Nh) array, i.e. full 
%                  size of state space. Child's value upon
%                  bequest.

[~,Ns, Nw    ] = size(Vin   );          % Input value function tells us how
                                        % many different health and prod.
                                        % states there are.
[N, ~,  ~, Nh] = size(aksell);          % Possible ak-combinations tell us 
                                        % how many asset and housing grid
                                        % points there are to be
                                        % considered.

Vout = zeros(N,Ns,Nw,Nh);               % Allocate array for results.                                  
% Tried parfor here, did not speed up code with N=21,Nw=4,Nh=5.
for j=1:Ns                              % Loop over child health:
    for i=1:Nw                          % Loop over productivity levels:       
        Vout(:,j,i,:) = interp1(par.akgrid(1:end),Vin(1:end,j,i),aksell(1:end,1,1,:),'pchip'); 
                                        % For j,i-combination, get
    end                                 % (N,1,1,Nh) array wit(1D inter-
end                                     % polation by splines).    
