function Vout = InterpSell(VrentExt,apsell,par)
% Interpolates to get house-selling values (can be used for either parents 
% or kids) when parent sells house.

% Input:
% VrentExt:        (N,Nextrap,Ns,Nw,Nw) array. Given input value function in 
%                  renting state (on extended parent grid for
%                  extrapolation).
% apsell:          (N,1,1,1,1,Nh) array. For which parent assets we want
%                  the interpolated values. Have to lie inside asset grid.
%                  If extrapolation is wanted, have to do this afterwards.
%
% Output:
% Vout:            (N,N,Ns,Nw,Nw,Nh) array. Interpolated values. 

[N,~,Ns,Nw,~   ] = size(VrentExt  );       % Input value function tells us how
                                        % many different health and prod.
                                        % states there are.
[~,~,~ ,~ ,~,Nh] = size(apsell);        % Possible ak-combinations tell us 
                                        % how many asset and housing grid
                                        % points there are to be
                                        % considered.
% SHOULD WE DO LOOPS HERE OR MULTI-DIMENSIONAL INTERPOLATION? INTERPOLATION
% IS WASTEFUL SINCE WE ONLY NEED TO EVALUATE OFF THE GRID POINTS FOR ap. 
% FOR NOW, COMPROMISE: LOOP OVER DISCRETE DIMENSIONS ONLY AND TWO 2D
% INTERPOLATION.
Vout = zeros(N,N,Ns,Nw,Nw,Nh);          % Allocate array with results.

aapp = ones(N,1,1,1,1,Nh).*apsell;      % Increase apsell to (N,N,1,1,1,Nh).
aakk = ones(1,N,1,1,1,Nh).*par.akgrid;  % Bring ak to size (N,N,1,1,1,Nh):
                                        % just stays the same.
% Tried parfor here, did not speed up code for N=21, Nw=4,Nh=4.
for j=1:Ns                              % Loop over child health:
    for i=1:Nw                          % Loop over parent productivity levels:       
        for k=1:Nw                      % Loop over kid prod. levels:
            Vout(:,:,j,i,k,:) = interp2(par.avecExt,par.akgrid,VrentExt(:,:,j,i,k),aapp,aakk,'spline');
                                        % For each j,i,k combination of
                                        % discrete states, do 2D
                                        % interpolation on the apExt-ak grid
                                        % (parent assets are extended).
                                        % The sampling points also have the
                                        % housing dimension, thus interp2
        end                             % returns a (N,N,1,1,1,Nh) array,
    end                                 % which is then written into the
end                                     % right position.

% surf( par.apgrid, par.akgrid, Vout(:,:,j,i,k,2) )
% Checked surface plots, looks very good.

