function xDer = GetForwDer1(x,da)
% Get forward deriviative of (N,N,Ns,Nw,Nw,Nh) array x in dim 1.
% Inputs:
% x:            (N,N,Ns,Nw,Nw,Nh) array with variable x.
% da:           (N-1)-by-1 vector with distances between grid points in
%               dimension 1. 
% Ouptut:
% xDer:         (N,N,Ns,Nw,Nw,Nh) array with forward derivative of x.

dx  = diff(x,1,1)./da;          % Get 1st forward difference in dim. 1:
                                % (N-1,N,...) array.
xDer= [dx; dx(end,:,:,:,:,:)];  % Add last element to return same-size array.                             
