function y = GetDrawProbDist(p,nDraw,x)
% Makes nDraw draws from a discrete random variable with realizations x
% that occur with probability p. Fast implementation: histc is a built-in
% function!
%
% Inputs:
% p:        Array of size nn=[n1,n2,...]. Probability of realizations. Need
%           not sum up to one, is normalized by code.
% nDraw:    Scalar. Number of draws. Default: 1.

% x:        Array of size nn=[n1,n2,...]. Realizations the r.v. takes.
%           If omitted, the function takes the vector (1:k)', where
%           k=numel(p), with the linear indeces of the bins in p.
%
% Output:
% nDraw-by-1 vector with draws of x from distribution.

if nargin<3                     % If no random variable x is handed over:
    x=(1:numel(p))';            % Create vector (1:k)' of indeces of bins
end                             % of p.
if nargin<2                     % If sizDraw is not handed over:
    nDraw=1;                    % draw a scalar.
end   

x = x(:);                       % Vectorize inputs in case they're arrays:
                                % k-by-1 vector.
p  = p(:)/sum(p(:));            % Normalize probability distribution:
                                % k-by-1 vector.
P = [0; cumsum(p)];             % Get cdf of x: (k+1)-by-1 vector.
u = rand([nDraw,1]);            % Draw column vector of uniform random
                                % numbers: nDraw-by-1.
[~,ind] = histc(u,P);           % ind: nDraw-by-1 vector telling us in which
                                % bin of the cdf each draw u(i) falls:
                                % This is the index of draw i on the
                                % x-vector.
y  = x(ind);                    % Read out realization of random variable.
