function y = GetDrawMultProbDist(p,x)
% Makes one draw from k discrete probability distributions with n
% realizations each. The code is efficient if k is large and n is small.
% For large n, rather use GetDrawProbDist.m and loop over the k variables.
%
% Inputs:
% p:        n-by-k matrix with probability distributions of k discrete 
%           random variables, each with n realizations (set probabilities
%           to zero to accommodate random variables with fewer
%           realizations). NOTE: Probabilities must some up to one in each
%           column! Commented out normalization to gain speed.
% x:        n-by-k matrix, optional. Realizations the r.v. takes.
%           If omitted, the function returns the index (a number between 1
%           and n) of the realization of i that is drawn in p(:,i).
%
% Output:
% 1-by-k vector with one draw from all k distributions.

[n, k] = size(p);               % Read out size of p.
if nargin<2                     % If no random variable x is handed over:
    x=(1:n)'*ones(1,k);         % Create matrix with vector [1,2,...n]' in 
end                             % in all conlumns

%PP = sum(p,1);                  % Normalize probability distributions:
%p  = p./PP(ones(n,1),:);        % Divide by sum of probabilities.
P = cumsum(p,1);                % Get cdf of x's: (n+1)-by-k matrix.
u = rand(1,k);                  % Draw row vector of uniform random
                                % numbers: 1-by-k.
ind = 1 + sum( u(ones(n,1),:) > P , 1);
                                % Get index of realization that is drawn:
                                % 1 if u is smaller than all points in cdf,
                                % 2 if u is greater than one point etc.
linInd = n*(0:1:k-1) + ind;     % Translate to a linear index for the
                                % n*k-by-1 vector x(:).
y = x(linInd);                  % Returns results.
                                
