function xDer = GetCentDer2(x,da)
% Get centered deriviative of (N,N,Ns,Nw,Nw,Nh) array x in dim 2.
% Inputs:
% x:            (N,N,Ns,Nw,Nw,Nh) array with variable x.
% da:           1-by-(N-1) vector with distances between grid points in
%               dimension 2. 
% Ouptut:
% xDer:         (N,N,Ns,Nw,Nw,Nh) array with centered derivative of x.

[N,~,Ns,Nw,~,Nh] = size(x);
dx  = diff(x,1,2)./da;           % All analogous to GetCenterDer1.
xDer= zeros(N,N,Ns,Nw,Nw,Nh); 
xDer(:,2:N-1,:,:,:,:) = ( dx(:,1:N-2,:,:,:,:) + dx(:,2:N-1,:,:,:,:) )/2;
xDer(:,1,:,:,:,:) = dx(:,  1,:,:,:,:);   
xDer(:,N,:,:,:,:) = dx(:,end,:,:,:,:);   
end
