function xDer = GetCentDer1(x,da)
% Get centered deriviative of (N,N,Ns,Nw,Nw,Nh) array x in dim 1.
% Inputs:
% x:            (N,N,Ns,Nw,Nw,Nh) array with variable x.
% da:           (N-1)-by-1 vector with distances between grid points in
%               dimension 1. 
% Ouptut:
% xDer:         (N,N,Ns,Nw,Nw,Nh) array with centered derivative of x.

[N,~,Ns,Nw,~,Nh] = size(x);     % Read out size of array;
dx  = diff(x,1,1)./da;           % Get 1st forward difference in dim. 1
                                % (N-1,N,...) array.
% xDerCheck= zeros(N,N,Ns,Nw,Nw,Nh);    % Set up output array.
xDer= zeros(N,N,Ns,Nw,Nw,Nh);    % Set up output array.
                                                                
xDer(2:N-1,:,:,:,:,:) = ( dx(1:N-2,:,:,:,:,:) + dx(2:N-1,:,:,:,:,:) )/2;
                                % For central points, just take average
                                % between up- and downward derivative.
    xDer(1,:,:,:,:,:) = dx(  1,:,:,:,:,:); % Take upward derivative on bottom,
    xDer(N,:,:,:,:,:) = dx(end,:,:,:,:,:); % and downward derivative on top.
end
