function xDer = GetBackwDer2(x,da)
% Get backward deriviative of (N,N,Ns,Nw,Nw,Nh) array x in dim 2.
% Inputs:
% x:            (N,N,Ns,Nw,Nw,Nh) array with variable x.
% da:           (N-1)-by-1 vector with distances between grid points in
%               dimension 1. 
% Ouptut:
% xDer:         (N,N,Ns,Nw,Nw,Nh) array with backward derivative of x.

dx  = diff(x,1,2)./da;          % Get 1st forward difference in dim. 2
                                % (N,N-1,...) array.
xDer= [dx(:,1,:,:,:,:), dx];    % Add first element to return same-size array.  