function out = GetApDot(IncP,ep,gk,gp)
% Obtains the law of motion for parent's assets.
% 
% Inputs:
% IncP:     (1,N,Ns, 1,Nw,Nh) array with parent's net income.
% ep:       (N,N,Ns,Nw,Nw,Nh) array with parents's consumption expenditure.
% gk:       (N,1,Nw,Nw,Nw,Nh) array or (N,N,Nw,Nw,Nw,Nh) with kid's gifts.
% gp:       (1,N,Nw,Nw,Nw,Nh) array or (N,N,Nw,Nw,Nw,Nh)with parent's
%           gifts.
% 
% Output:
% (N,N,Ns,Nw,Nw,Nh) array with law of motion for parent's assets.

out = IncP - ep;    % Income minus spending is parent's budget before gifts 
                    % (Matlab extends IncP in dimensions 1 and 4 here).
if size(gk,2)==1    % If there are only gifts when parent broke:
    out(:,1,:,:,:,:) = out(:,1,:,:,:,:) + gk; % Add gifts received from kid 
                     % when parent broke.
else                % Otherwise, add at all positions..
    out = out + gk; 
end
if size(gp,1)==1    % Same for parent's gifts: subtract them.
    out(1,:,:,:,:,:) = out(1,:,:,:,:,:) - gp;  
else
    out = out - gp;
end
