function out = GetAkDot(IncK,ek,gk,gp)
% Obtains the law of motion for kid's assets.
% 
% Inputs:
% IncK:     (N,1,k,Nw, 1, 1) array with kid's net income.
% ek:       (N,N,k,Nw,Nw,Nh) array with kid's consumption expenditure.
% gk:       (N,1,k,Nw,Nw,Nh) array or (N,N,k,Nw,Nw,Nh) with kid's gifts.
% gp:       (1,N,k,Nw,Nw,Nh) array or (N,N,k,Nw,Nw,Nh) with parent's
%           gifts.
% Output:
% (N,N,k,Nw,Nw,Nh) array with law of motion for kid's assets.

out = IncK - ek;    % Income minus spending is kid's budget before gifts 
                    % (Matlab extends IncK array in dimensions 2, 5, and 6) 
if size(gk,2)==1    % If gifts only flow to broke parents:                    
    out(:,1,:,:,:,:) = out(:,1,:,:,:,:) - gk; % Subtract gifts given by kid. 
else                % Otherwise, subtract them at all positions.
    out = out - gk;
end
if size(gp,1)==1    % If gifts only flow to broke kids:
    out(1,:,:,:,:,:) = out(1,:,:,:,:,:) + gp; % Add gifts received.
else
    out = out + gp;
end

