function [w, q, qma, qfhc, qsc] = EqmPrices(Ay,Af,yMA,FHCrat,SCrat)
% Obtain equilibrium prices given productivity parameters. Put this into a
% function to have it in one place.
% 
% Inputs:
% Ay:       Scalar. Goods-sector productivity.
% Af:       Scalar. Productivity in LTC sector.
% yMA:      Scalar. Cost to government of MA slot.
% FHCrat:   Scalar. How much more formal home care costs (in terms of basic
%           care services) than a nursing home. Is greater 1 since NH has 
%           economies of scale.
% SCrat:    Scalar. How much more skilled nursing-home care costs with
%           respect to basic care services.
% 
% Outputs:
% w:        Scalar. Wage rate.
% q:        Scalar. Effective price of privately-paid care, taking into
%           account utility discount Cf.
% qsc:      Scalar. Cost of skilled nursing-home care.
% qma:      Scalar. Cost of Medicaid provision to government.
% qfhc:     Scalar. Cost of formal home care.

w   = Ay;                       % See calibration appendix.
q   = w/Af;
qma = w/Af + yMA;
qfhc= FHCrat*w/Af;
qsc = SCrat*q;      

