function out = Dutilde(e4,h,n,par)      
% Returns the derivative of "indirect flow felicity" of spending e4 in 
% stage 4 (only consumption for owners, consumption plus renting for renters) given
% housing state h and n persons per household in.
%
% Inputs:
% e4:       array. Stage-4 spending of household.
% h:        array (same size as e4) or scalar. Housing state (equals h0 for
%           renters)
% n:        array (same size as e4) or scalar. Household size
% par:      structure. Must contain parameters needed by functions Ash.m 
%           and thetah.m: g, r, xi, deltaHouse, h0, phi.
% 
% Output:   array (same size as e4)

A     = Ash(n,h,par);           % Get marginal-utility shifter A(n,h).
theta = thetah(h,par);          % Get curvature of marginal utility.
out   = A .* e4.^(-theta) ;     % Get marginal utility.
