function out = Duinvtilde(Va,h,n,par) 
% Returns optimal stage-4 expenditures e~4 (i.e. consumption spending = total
% spending - housing depreciation for
% owners, consumption plus rent spending for renters; or the inverse of 
% marginal felicity of stage-4 expenditures) given the marginal value of 
% saving Va = dV/da, for n persons per household (default is 1), where housing 
% is h.
%
% Inputs:
% Va:       array. Marginal value of savings for household (derivative of
%           value function with respect to own asset)
% h:        array (same size as e4) or scalar. Housing state (equals h0 for
%           renters)
% n:        array (same size as e4) or scalar. Household size.
% par:      structure. Must contain parameters needed by functions Ash.m 
%           and thetah.m: g, r, xi, deltaHouse, h0, phi.
%
% Output:   array of same size as Va. Optimal stage-4 consumption
%           expenditures.

A     = Ash(n,h,par);           % Get marginal-utility shifter.
theta = thetah(h,par);          % Get curvature of utilde.
out   = (A./Va).^(1./theta);    % Calculate optimal expenditures e4.
