function DisplaySettings(par,opt)
% Displays the settings in structures par and opt.

% Infer altruism measures from the alphas:
altrk = (par.alphak).^( 1/(par.xi*(par.g-1)+1) );
altrp = (par.alphap).^( 1/(par.xi*(par.g-1)+1) );


% First, display grid-related settings:
fprintf('N=%2.0f, aup=%4.0f, Nw=%1.0f, dt=1/%2.0f, hvec: [', ...
        [par.N  , par.aup  , par.Nw  , 1/opt.dt  ])
for ih=1:par.Nh                     % Display the housing vector.
    fprintf('%.0f',par.hvec(ih))
    if ih<par.Nh
        fprintf(',')
    end
end
fprintf('].\n') 
fprintf('Asset grid: [%1.0f,%1.0f,%1.0f,%1.0f,...,%1.0f,%1.0f].\n',...
               par.avec([1,  2, 3, 4,    par.N-1,par.N] )       );  
fprintf('Productivity grid: [')
fprintf('%1.2f,'   ,par.epsvec(1:end-1))    % Print out all but last state.
fprintf('%1.2f].\n',par.epsvec(  end  ))    % Print last state.
 
% Then, show other parameters of interest:
fprintf( 'altrp=%4.4f, altrk=%4.4f, rho=%4.4f, omega=%4.2f, gamma=%4.2f.\n',...
        [ altrp      , altrk      , par.rho  , par.omega,   par.g])
fprintf( 'Cma=%4.2f,  fracLtcBasic=%4.3f, QmaxFact=%4.2f.\n',...
        [ par.Cma  ,  par.fracLtcBasic ,  par.QmaxFact     ]   )    
if par.TaxCpl        , fprintf('K-income taxed.\n') , else, fprintf('K-income NOT taxed.\n')          , end
