function llOut = CopyStruct(llIn,sInd)
% Copies all the structure llIn, for each field taking only the health
% indeces sInd (on dimension 3).
% 
% Inputs:
% llIn:         Structure.
% sInd:         Scalar integer. Which index of the health dimension to copy. 
%
% Output:       Structure with the same fields as llIn.

fdNames = fieldnames(llIn);         % Read out 1-by-L structure with all
L = numel(fdNames);                 % field names in input.

for ifd=1:L                         % Loop over all fields.
    if size(llIn.(fdNames{ifd}),3)>1 % If there is a non-degenerate health
        llOut.(fdNames{ifd}) = llIn.(fdNames{ifd})(:,:,sInd,:,:,:);
    else                            % dimension, copy only index sInd.
        llOut.(fdNames{ifd}) = llIn.(fdNames{ifd});        
    end                             % Otherwise, copy everything.
end