function ZalnTom = ContinuationValueAln(ZI,hAln,DeathValAln,dt)
% Obtains continuation value for case where kid is alone on the world.
%
% Inputs:
% ZI:           Array of dim. (N+2,k,Nw,Nh), where k=1 or k=3 (LTC states
%               may be included or not): Value function Z tomorrow, with
%               extrapolated values. 
% hAln:         STRUCTURE containing the hazard of jumping to adjacent grid
%               points, each is a (N,k,Nw,Nh) array as created by
%               GetJumpHazardsAln.m. Has to contain the fields read out in 
%               the beginning of the function.
% DeathValAln:  (N,k,Nw,Nh) array or scalar.Value function when old dies 
% dt:           Scalar. The time increment.
%
% Output:
% Array of dim. (N,k,Nw,Nh) with continuation value tomorrow (after time
% interval of dt) for each grid point.

PmAln   = 1-hAln.leave*dt;  % Probability of staying at same grid point.
PuAln   = hAln.upAk*dt;     % Prob. of going one wealth level up,
PdAln   = hAln.dnAk*dt;     % Prob. of going one wealth level down,
PdthAln = hAln.death*dt;    % Prob. of death.

ZalnOld = ZI(2:end-1,:,:,:);% Get value function on regular grid (without 
                            % extrapolated values)
JumpValVec = hAln.JumpMat * ZalnOld(:) * dt;
                            % Get value from jumping on vectorized space 
                            % (have to use (N,k,Nw,Nh) value fct here).
                            % Note: JumpMat has zeros on diagonal! The
                            % negative terms for the hazard leaving are in
                            % hAln.leave, and thus already considered in
                            % PmAln.
JumpValAln = reshape( JumpValVec, size(PmAln));
                            % and convert to array form. Get
                            % continuation value:
ZalnTom = PmAln  .* ZI(2:end-1,:,:,:) + ...     % Stay,
          PuAln  .* ZI(3:end  ,:,:,:) + ...     % wealth up,
          PdAln  .* ZI(1:end-2,:,:,:) + ...     % wealth down,
          JumpValAln                  + ...     % plus jump value,
          PdthAln.* DeathValAln;                % and death event.
