% HELPERFCT
%
% Files
%   A                     - Returns the marginal-utility shifter A 
%   Arr2DiagSparseMat     - Create sparse diagonal matrix
%   Arr2LinInd            - Turns array indices into an index for linear indexing
%   Ash                   - Returns the marginal-utility shifter A(n,h)
%   BequestValue          - Returns child's value upon bequest under non-linear grid in alone economy
%   BuyHouseValue         - Returns the value for a 65-year old who just entered retirement 
%   CdfProbDist           - Returns the cumulative distribution function
%   Consumption2          - Given the value function (ll.Vold, ll.Wold), get optimal (unconstrained) 
%   ConsumptionAln        - Obtain optimal consumption expenditure (ekAln), the value function on
%   ContinuationValue2    - function out  = GetContinuationValue2(F,h,DeathVal,dt,par)
%   ContinuationValueAln  - Obtains continuation value for case where kid is alone on the world.
%   CopyStruct            - Copies a structure. 
%   DisplaySettings       - Displays the settings in structures par and opt.
%   dTaxSweden            - Obtain tax increment needed to finance universal LTC coverage 
%   Duinvtilde            - Returns optimal stage-4 expenditures e4 
%   Dutilde               - Returns the derivative of "indirect flow felicity" of spending e4 
%   EqmPrices             - Obtain equilibrium prices given productivity parameters.
%   ExtrapValFctCRRA      - Extrapolates a CRRA value function 
%   GetAkDot              - Obtains the law of motion for kid's assets.
%   GetApDot              - Obtains the law of motion for parent's assets.
%   GetBackwDer1          - Get backward derivative in dim 1
%   GetBackwDer2          - Get backward derivative in dim 2
%   GetBargainSolIC       - Bargaining solution for disabled renters
%   GetBargainSolSell     - Obtains bargaining solution and transfer for homeowners 
%   GetBKalloc2           - Returns both players' transfers and realized stage-4 expenditures
%   GetBKallocFloor2      - Returns both players' transfers and realized stage-4 expenditures 
%   GetCentDer1           - Get centered derivative in dim 1
%   GetCentDer2           - Get centered derivative in dim 2
%   GetConditionalMean    - Calculates conditional mean of random variable
%   GetConditionalMeanPanel - Calculates conditional mean of random variable 
%   GetDrawMultProbDist   - Makes one draw from k discrete probability distributions with n
%   GetDrawProbDist       - Makes nDraw draws from a discrete random variable with realizations x
%   GetForwDer1           - Get forward derivative in dim 1
%   GetForwDer2           - Get forward derivative in dim 2
%   GetTransMatAR1        - Sets up a transition matrix for (mean-zero) Ornstein-Uhlenbeck
%   GiniProbDist          - Returns Gini coefficient for a random variable
%   HazMatLTC345          - Given LTC hazards 'hazLTC345', return sparse transition matrix 
%   InterpSell            - Interpolation to get hous-selling values
%   InterpSellAln         - Interpolation to get hous-selling values
%   JumpHazards2          - Returns the hazard rates of leaving a grid point towards neighboring grid 
%   JumpHazardsAln        - Calculates hazards of leaving the current grid point in the Markov-chain
%   KKstarInflow          - Obtains the outflow from stardom
%   KKTransMat            - Constructs hazard matrix for productivities a la Kindermann & Krueger
%   kronm                 - Fast Kronecker matrix multiplication, for both full and sparse matrices 
%   Lin2ArrInd            - For array of size 'siz', turns linear index (read: X(11)) into
%   LinInd2DimInd         - Inputs:
%   logncdf               - get cdf of lognormal with parameters mu and sigma
%   LTChazard2            - Function returns polynomial coefficients to approximate the hazards of
%   MAaverage             - Takes the average between one variable for the MA scenario (varMA) and
%   NetIncKid             - Returns net income of a kid household of age j with assets ak,
%   NetIncPar             - Returns net income of a parent household of age j with assets ap,
%   normcdf               - normal CDF -- NOT FROM MATLAB TOOLBOX BUT DOWNLOADED AND CHANGED
%   norminv               - THIS IS NOT THE FUNCTION FROM THE STATS TOOLBOX, BUT A SELF-CREATED SMALL
%   normpdf               - Normal probability density function (pdf).
%   PanelIndices          - Returns linear indeces of panel members.
%   PatchToArray          - Patches the column vector x to create array of size ArraySize. 
%   phi                   - Approximates heavy-side step function.
%   ProdProcess           - Productivity process for labor earnings
%   RatePoly2             - Obtains rates (hazard rates or probabilities) for age j and productivity
%   SaveResults           - Save baseline results on the Desktop (don't use Dropbox... this takes a
%   SavingsHaz            - Given drift and variance of the law of motion for assets, gives back the
%   spkron                - Fast computation of Kronecker product for sparse matrices.
%   StarFrac              - Fraction of stars under ergodic distribution
%   tax                   - Returns the tax rate from the function estimated by Gouveia & Strauss for
%   TestRamWriteSpeed     - Tests how fast a machine writes to memory when going above RAM.
%   thetah                - Returns power coefficient theta(h) of marginal utility in liquid
%   u                     - Returns flow utility for the generation of consuming c for nP persons per
%   uc                    - Returns marginal utility of consumption expenditure c for a generation
%   ucinv                 - Returns optimal consumption expenditure 
%   utilde                - Returns "indirect flow felicity" of spending e4 in stage 4 
