function [ekAln, ZalnAk, ZalnI, akDotAln, MAaln] = ConsumptionAln(Zaln,hgridAln,nnkAln,NetInc,par)
% Obtain optimal consumption expenditure (ekAln), the value function on
% the extended grid (ZalnI), and the law of motion of assets (akDotAln) for
% the kid when it is alone (Aln) in the world. The kid household has NetInc
% as the net household income.
%
% Inputs:
% Zaln:         Array of dim. (N,k,Nw,Nh), where k=1 or k=2 (sickness state).
%               Value function of the kid when alone.
% hgridAln:     Array of dim. (1,1,1,Nh) or scalar. Housing size for kid.
% nnkAln:       Array of dim. (1,k,Nw,1) or scalar. Number of persons in a
%               kid household.
% NetInc:       Array of dim. (N,k,Nw,Nh). Net income of kid household
% par:          STRUCTURE. contains parameters.
% opt:          Structure. Contains algorithm options.
%
% Outputs:
% ekAln:        Array of dim. (N,k,Nw,Nh). Optimal consumption expenditure.
% ZalnI:        array of dim. (N+2,k,Nw,Nh). Extended value function with
%               extrapolated values for the wealth grid.
% akDotAln:     array of dim. (N,k,Nw,Nh). Law of motion for assets.
% MAaln:        array of dim. (1,1,Nw,Nh). Medicaid decision.

Cma = par.Cma; dak = par.dak;          % dak: (N-1)-by-1 vector.

% Read out parameters

[N,k,Nw,Nh] = size(Zaln);               % Get size of inputs.

dZ    = diff(Zaln,1,1) ./ dak;                 % Difference the value fct.
xCentDer   = zeros(N,k,Nw,Nh);       % Set up array with centered derivative  % ??? CAN ADJUST CENTERED DIFF. FOR NON-LINEAR GRID
xCentDer(2:N-1,:,:,:)    = ( dZ(1:N-2,:,:,:) + dZ(2:N-1,:,:,:) )/2;
xCentDer(1,:,:,:)    = dZ(  1,:,:,:); % Take upward derivative on bottom,
xCentDer(N,:,:,:)    = dZ(end,:,:,:); % and downward derivative on top

ZalnAk  = xCentDer;

ekAln    = Duinvtilde(ZalnAk, hgridAln, nnkAln, par);
% Get unconstrained consumption choice:
% e~ in Stage 5, i.e. consumption spending
% = total expenditure - housing depr.
% for owners.
if any(ZalnAk(:)<0)
    ekMax = 5*NetInc.*ones(size(ZalnAk));
    ekAln(ZalnAk<0) = ekMax(ZalnAk<0);    % Make them consume a maximum amount if value of savings negative.
end

NoConsFeas = NetInc(1,:,:,:)<=0;        % Calculate for which broke hh
% consumption would have to be neg.
% (will choose MA or sell house).
ekconstr = NetInc(1,:,:,:);             % Get constrained consumption;
ekconstr(NoConsFeas) = par.valNoConsFeasible;    % set this to very low value
% for those with no feasible
% choice: avoid -Inf (or complex
% numbers), these will choose MA or
% sell house.
ekAln(1,:,:,:) = min( ekAln(1,:,:,:), ekconstr);
% Impose the constraint.

akDotAln           = NetInc - ekAln;    % Implied law of motion for ay.
akDot0             = akDotAln(1,:,:,:); % Set law of motion to 0 for those
akDot0(NoConsFeas) = 0;                 % who don't have a feasible
akDotAln(1,:,:,:)  = akDot0;            % consumption plan.

% When LTC is possible (k>1): MA option (now also those WITH houses)
% Eligible: indices (1,2:k,:,:): zero liquid assets, have LTC need.
if k>1                                  %  MA decision:      % MADEC
    MAaln = ( ekAln(1,2:k,:,:) < Cma ); % choose consumption floor if
    ekAln(1,2:k,:,:) = max( Cma, ekAln(1,2:k,:,:) );
    akDot0 = akDotAln(1,2:k,:,:);       % consumption is below this floor.
    akDot0(MAaln) = 0;                  % House owners will sell house
    akDotAln(1,2:k,:,:) = akDot0;       % in stage before if they can't
end                                     % afford nursing home.

ZalnNk = Zaln(end,:,:,:) + dak(end)*ZalnAk(end,:,:,:);
% Take last da for extrapolation.
ZalnI = zeros(N+2,k,Nw,Nh);             % Create array for Z with extrapo-
ZalnI(2:N+2,:,:,:) = [Zaln; ZalnNk];    % lated values on top, leave bottom
% empty because p_down=0 there.
