function [F,xord,pord] = CdfProbDist(xdat,pdat)
% Inputs:
% xdat:     Array of any size with total number of elements N. Values the 
%           random variable takes.
% pdat:     Array of same size as xdat, optional. Probabilities of the 
%           values in xdat. Equal probabilities are assumed if not handed
%           over.
% Outputs:
% F:        N-by-1 vector. Cumulative distribution function (cdf) evaluated 
%           at the ordered vector of points xord.
% xord:     N-by-1 vector. xdat in ascending order.
% pord:     N-by-1 vector. Probabilities in the same order as xord.

if nargin<2                             % If probabilities are not handed
    pdat = ones(size(xdat));            % over: Give same weight to each
end                                     % realization.

xdat = xdat(:);                         % Vectorize inputs, normalize
pdat = pdat(:)/sum(pdat(:));            % prob. distribution to sum up to 1.                             

[xord, ind] = sort(xdat);               % Sort values in x.
pord = pdat(ind);                       % Sort frequencies in the same way.
F = cumsum(pord);                       % Get cdf.
