function V1246 = BequestValue(BeqV,beq126,par)

% Input:
% BeqV:            Value upon bequest: (N,1,Nw) array. Child's value
%                  function on ak-grid when alone.
% beq126:          Size of bequest, (N,N,Nh) array. , varies on asset and 
%                  housing dimensions
%
% Output:
% V1246:           Interpolated value (N,N,1,Nw,1,Nh) array, i.e. full 
%                  size of state space. Child's value upon
%                  bequest. Varies on asset and housing dimensions and
%                  kid's productivity.

N = par.N;  Nw = par.Nw;  Nh = par.Nh;
V1246 = zeros(N,N,1,Nw,1,Nh);           % Allocate (N,N,1,Nw,1,Nh) array for result.
for i=1:Nw                              % Loop over productivity levels:
    ZZi = interp1(par.akgrid,BeqV(:,1,i),beq126,'spline'); 
                                        % For each level, interpolate on 
                                        % BeqV (1D interpolation by
                                        % splines). Do this for all
                                        % beq-values (N-by-N).
    V1246(:,:,1,i,1,:) = reshape(ZZi,[N,N,1,1,1,Nh]);
end                                     % Then reshape and record result.
