function out = Ash(n,h,params)
% Returns the marginal-utility shifter A(n,h), both for owners and renters
%
% Inputs: 
% n:      array or scalar. Household size.
% h:      array (same size as household size) or scalar. Housing.
% params: structure. Must contain parameters read out in beginning of
%         function: g, r, xi, deltaHouse, h0, phi, omega.
%
% Output: array (same size as n and h). Marginal-utility shifter A(n,h)

g = params.g;   xi = params.xi;  omega = params.omega;
phi = params.phi; h0 = params.h0; r = params.r;
deltaHouse = params.deltaHouse;    % Read out parameters. 
rentersChoose = params.rentersChoose;  

%own = h > 1;
own = abs(h-h0) > 10^(-10);        % Variable for owners: house size not 
                                    % equal to renter size -- leave some 
                                    % room for computational error.
Cs     = n .* phi(n).^(g-1);        % Term related to household size.

if rentersChoose                    % When renters decide apartment size:
    Aown   = xi * Cs .* (omega*h).^(-(1-xi)*(g-1)) ; 
                                    % Get A(n,h) for owners,...
    Arent  = Cs *  ( xi^xi * (1-xi)^(1-xi) / (r+deltaHouse)^(1-xi) )^(1-g) ;
                                    % ...then A_r(h) for renters,     
    out    = own.*Aown + ~own.*Arent; % ...and bring together the two.
else                       
    housServ = (1 + own.*(omega-1) ).* h;
                                    % Get housing services: include warm 
                                    % glow for owners.
    out    = xi * Cs .* housServ.^(-(1-xi)*(g-1)) ;
end                                 % Then get utility shifter.

