function LinInd = Arr2LinInd(ArrInd,siz)
% For array of size 'siz', turns array indices (read: X(1,1,2)) into
% an index for linear indexing (read: X(11)).
%
% Input:
% siz:      1 x nDim row vector. Size of array with multiple dimensions.
% ArrInd:   N-by-nDim matrix. Each row gives array indeces of one element 
%           in the nDim-dimensional array, have N such elements in total.
%
% Output:
% N-by-1 vector. Linear index of the N elements on the array.
%
% Note: Comparable to Matlab function sub2ind, but takes in all indices at
% once and is faster.

blockSiz = [1, cumprod(siz(1:end-1))];      % Get size of 'blocks' below 
                                            % each dimension.
LinInd   = 1 + (ArrInd-1) * blockSiz';      % Return linear index.
