function out = A(nP,nHH,f,par)
% Returns the marginal-utility shifter A given number of persons in
% household (nP), number of households in the generation, and formal-care
% status (1 if receiving formal care, 0 if not).
% 
% Inputs: arrays of same size or scalars.
% f:                            Formal care (1), 0 for healthy and 
%                               informal-care and for kids.
% nP:                           Number of persons in household.
% nHH:                          Number of households.
% par:                          Structure with parameters.
%
% Output: Array of same size as inputs.

g   = par.g;                % Read out parameters from 'par'.
eta = par.eta;
phi = par.phi;              
                            % Calculate utility shifter:
out = nP .* phi(nP).^(g-1) .* nHH.^g .* exp(-eta*(1-g)*f);
