(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    126220,       3175]
NotebookOptionsPosition[    125700,       3157]
NotebookOutlinePosition[    126133,       3174]
CellTagsIndexPosition[    126090,       3171]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 StyleBox["Sandor Balog |  Adolphe Merkle Institute | Universit\[EAcute] de \
Fribourg | Switzerland \n\n2022.12.24\n",
  FontSize->10],
 StyleBox["Mathematica",
  FontSize->10,
  FontSlant->"Italic"],
 StyleBox[" Version 13.0\nsandor.balog@unifr.ch\n\nThis Wolfram / Mathematica \
notebook accompanies the article \[OpenCurlyDoubleQuote]The Influence of \
Fluid Menisci on Nanoparticle Dosimetry in Submerged Cells\
\[CloseCurlyDoubleQuote] written by Christina Glaubitz, Laetitia Haeni, Eva \
Su\[SHacek]nik, Barbara Rothen-Rutishauser, Sandor Balog, and Alke Petri-Fink\
\n\nKeywords: In vitro particle dosimetry, Fluid meniscus, Mathematical \
modelling\n\nThe mathematical model is a continuous and deterministic model \
that comprises two second-order nonlinear and linear partial differential \
equations with corresponding boundary and initial conditions. The model \
addresses the impact of fluid the meniscus in cylindrical wells, and the \
transport equation (advection-diffusion) in three plus one dimensions: \
spatial coordinates and time. The advection-diffusion model is evaluated via \
finite element method, addressing non-interacting colloidally stable \
particles in a quiescent fluid.",
  FontSize->10]
}], "Title",
 Editable->False,
 CellChangeTimes->{{3.566984688178922*^9, 3.566984737163008*^9}, {
   3.566984821465556*^9, 3.5669848219179573`*^9}, {3.5669861535378966`*^9, 
   3.5669861628511133`*^9}, {3.57079252871795*^9, 3.5707925290277886`*^9}, {
   3.5711193320370693`*^9, 3.5711193332271166`*^9}, {3.573047011938319*^9, 
   3.573047012718321*^9}, {3.5730588734616423`*^9, 3.5730589112449083`*^9}, 
   3.573196954132554*^9, {3.573197218843606*^9, 3.573197262323872*^9}, {
   3.5731979107223263`*^9, 3.5731979174306707`*^9}, {3.5817850896271*^9, 
   3.5817850919983044`*^9}, {3.582427660602809*^9, 3.5824276698431787`*^9}, {
   3.589996766323708*^9, 3.5899967688041124`*^9}, {3.5900375598503504`*^9, 
   3.590037560240351*^9}, {3.5900499819684625`*^9, 3.5900499847296677`*^9}, {
   3.590915326222548*^9, 3.5909153264253483`*^9}, 3.5910114176792173`*^9, {
   3.5910752495320854`*^9, 3.59107526363451*^9}, {3.5910753619989967`*^9, 
   3.5910753871937294`*^9}, 3.5910777636367216`*^9, 3.59119873247546*^9, {
   3.5915251003240795`*^9, 3.5915251004644794`*^9}, {3.599997780311984*^9, 
   3.5999977899116964`*^9}, {3.617359885900009*^9, 3.6173598877876215`*^9}, {
   3.619933483293124*^9, 3.619933484899935*^9}, {3.6206345053639855`*^9, 
   3.6206345055199857`*^9}, {3.625547241001376*^9, 3.6255472433856144`*^9}, {
   3.625978803203124*^9, 3.6259788035463157`*^9}, {3.627643118127137*^9, 
   3.6276431201421776`*^9}, {3.641788915072398*^9, 3.6417889189597874`*^9}, {
   3.6481929679700403`*^9, 3.6481929766151686`*^9}, {3.6610646606149883`*^9, 
   3.661064667606288*^9}, {3.676880318068573*^9, 3.676880322509017*^9}, {
   3.680944166995165*^9, 3.6809441696627827`*^9}, {3.6832882728250437`*^9, 
   3.683288274895851*^9}, {3.7066003259094515`*^9, 3.70660032631717*^9}, {
   3.765604871397221*^9, 3.765604873638276*^9}, {3.880853596061011*^9, 
   3.8808536729129124`*^9}, {3.880853758925926*^9, 3.880853837251753*^9}, {
   3.8808538880553985`*^9, 3.88085391644296*^9}, {3.880854177098057*^9, 
   3.880854178051403*^9}, {3.880854231424673*^9, 3.880854231804138*^9}, {
   3.8808544173176517`*^9, 3.880854434239661*^9}, {3.8808650667876987`*^9, 
   3.8808650671970406`*^9}, {3.880865112064717*^9, 3.8808651630888324`*^9}, {
   3.880870093532742*^9, 3.8808701191134834`*^9}, {3.8808733209575725`*^9, 
   3.880873321244728*^9}, {3.8808737982267494`*^9, 3.880873826553402*^9}, {
   3.880874213497046*^9, 3.8808742172791843`*^9}, {3.8808744164074106`*^9, 
   3.8808744262296724`*^9}, {3.8808816163602066`*^9, 3.8808816186280336`*^9}},
 FontSize->10,
 FontTracking->"Plain",
 FontColor->GrayLevel[1],
 Background->GrayLevel[
  0],ExpressionUUID->"92af6e7b-8264-4e2a-935f-b6903976d59f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", "dirS", "]"}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"dir1", "=", 
   RowBox[{"CreateDirectory", "[", 
    RowBox[{"fn", "=", 
     RowBox[{
      RowBox[{"DateString", "[", "\"\<ISODate\>\"", "]"}], "<>", "\"\<_\>\"", 
      "<>", 
      RowBox[{"DateString", "[", "\"\<Hour\>\"", " ", "]"}], "<>", 
      "\"\<-\>\"", "<>", 
      RowBox[{"DateString", "[", "\"\<Minute\>\"", "]"}], "<>", "\"\<-\>\"", "<>", 
      RowBox[{"DateString", "[", "\"\<Second\>\"", "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SetDirectory", "[", "dir1", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<Input parameters are set and folder is created.\>\"", ",", 
      RowBox[{"FontColor", "\[Rule]", "Red"}], ",", 
      RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
      RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vol", "=", " ", 
   RowBox[{"vol", " ", "milli", " ", "liter"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"conc0", "=", 
   RowBox[{"c0", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"micro", " ", "g"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"milli", " ", "liter"}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"massTot", "=", 
    RowBox[{"conc0", "  ", "vol"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"T", "=", 
    RowBox[{"273.15", "+", "TCelsius"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"0.0000383897", ",", "432.9089", ",", "160.41438"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"visc", "[", "T_", "]"}], ":=", 
   RowBox[{"a", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"b", "/", 
      RowBox[{"(", 
       RowBox[{"T", "-", "c"}], ")"}]}], "]"}]}]}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Viscosity", " ", "of", " ", "water", " ", "as", " ", "a", " ", "function",
     " ", "of", " ", "temperature", " ", 
    RowBox[{"(", 
     RowBox[{"Pa", " ", "s"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 StyleBox[
  RowBox[{
   RowBox[{"kB", " ", "=", 
    RowBox[{"1.38", " ", 
     SuperscriptBox["10", 
      RowBox[{"-", "23"}]]}]}], ";"}],
  FontColor->GrayLevel[0]], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Eta]", "=", 
   RowBox[{"visc", "[", "T", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Diff", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"kB", " ", "T"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"6", " ", "\[Pi]", " ", "\[Eta]"}], " ", ")"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"rh", " ", 
         SuperscriptBox["10", 
          RowBox[{"-", "9"}]]}], " ", ")"}]}], ")"}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Particle", " ", "translational", " ", "diffusion", " ", 
    RowBox[{"coeff", ".", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["m", "2"], "/", "s"}], ")"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Sv", "=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"2", "gr"}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"9", "\[Eta]"}], ")"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"\[Rho]", "-", "ro"}], ")"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"rh", " ", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}], ")"}], "2"]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Particle", " ", "settling", " ", "velocity", " ", 
    RowBox[{"(", 
     RowBox[{"m", "/", "s"}], ")"}]}], " ", "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig1", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "/", "Sv"}], " ", ")"}], 
       RowBox[{"\[Sqrt]", 
        RowBox[{"(", 
         RowBox[{"Diff", "/", 
          RowBox[{"(", 
           RowBox[{"t", " ", "3600"}], " ", ")"}]}], ")"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "1", ",", "Tep"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<Particle transport factor\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"All", ",", 
           RowBox[{"24", "+", "1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Time (h)\>\"", ",", " ", "\"\<\[Epsilon]\>\""}], " ", 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageMargins", "\[Rule]", 
       RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Round", "[", 
       FractionBox["Diff", 
        RowBox[{"3600", " ", 
         SuperscriptBox["Sv", "2"]}]], "]"}], "<", "Tep"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ms", "=", 
       RowBox[{
       "\"\<Particle transport is dominated by translational diffusion until \
\>\"", "<>", 
        RowBox[{"ToString", "[", 
         RowBox[{"Round", "[", 
          FractionBox["Diff", 
           RowBox[{"3600", " ", 
            SuperscriptBox["Sv", "2"]}]], "]"}], "]"}], "<>", 
        "\"\< h.\>\""}]}], ";"}], "\[IndentingNewLine]", ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
      "ms", "=", 
       "\"\<Particle transport is dominated by translational \
diffusion.\>\""}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "\"\<Particle hydrodynamic radius (nm):\>\"", ",", " ", 
          "\[IndentingNewLine]", 
          "\"\<Particle mass density (g/\!\(\*SuperscriptBox[\(m\), \
\(3\)]\)):\>\"", ",", "\[IndentingNewLine]", "\"\<Transport: \>\"", ",", " ", 
          "\[IndentingNewLine]", 
          "\"\<Particle concentration (\[Mu]g/mL):\>\"", ",", 
          "\[IndentingNewLine]", 
          "\"\<Administered particle mass (\[Mu]g): \>\"", ",", 
          "\[IndentingNewLine]", "\"\<Well radius (mm):\>\"", ",", 
          "\[IndentingNewLine]", 
          "\"\<Boundary model of axis-symmetric Young-Laplace equation: \>\"",
           " ", ",", "\[IndentingNewLine]", 
          "\"\<Contact angle (\[Degree]): \>\"", ",", "\[IndentingNewLine]", 
          "\"\<Fluid volume in well (mL:\>\"", ",", "\[IndentingNewLine]", 
          "\"\<Fluid surface tension (N/m):\>\"", ",", "\[IndentingNewLine]", 
          "\"\<Fluid mass density (g/\!\(\*SuperscriptBox[\(m\), \(3\)]\)):\>\
\"", ",", "\[IndentingNewLine]", "\"\<Fluid temperature (\[Degree]C):\>\"", 
          ",", "\[IndentingNewLine]", "\"\<Number of annuli: \>\"", ",", 
          "\[IndentingNewLine]", 
          "\"\<Particle translation diff. coeff. (\!\(\*SuperscriptBox[\(m\), \
\(2\)]\)/s):\>\"", ",", " ", "\[IndentingNewLine]", 
          "\"\<Particle settling velocity (m/s):\>\"", ",", " ", 
          "\[IndentingNewLine]", 
          "\"\<Neumann boundary value at well bottom (1/m)\>\"", ",", " ", 
          "\[IndentingNewLine]", "\"\<Time end-point (h)\>\"", ",", 
          "\[IndentingNewLine]", "\"\<Folder to save the results:\>\""}], 
         "}"}], " ", ",", "\[IndentingNewLine]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1.", " ", "rh"}], " ", ",", 
          RowBox[{"1.", " ", "\[Rho]"}], " ", ",", "ms", ",", 
          RowBox[{"1.", " ", "c0"}], ",", 
          RowBox[{"1.", " ", "massTot", " ", 
           RowBox[{
            SuperscriptBox["10", "6"], "/", "g"}]}], ",", 
          RowBox[{"1.", " ", "R"}], ",", "BC", ",", "\[Theta]", ",", 
          RowBox[{"1.", " ", 
           RowBox[{"vol", "/", 
            RowBox[{"(", " ", 
             RowBox[{"milli", " ", "liter"}], ")"}]}]}], ",", 
          RowBox[{"1.", " ", "St"}], ",", 
          RowBox[{"1.", " ", "ro"}], ",", 
          RowBox[{"1.", " ", "TCelsius"}], ",", 
          RowBox[{"1.", " ", "v"}], ",", 
          RowBox[{"1.", " ", "Diff"}], ",", 
          RowBox[{"1.", " ", "Sv"}], ",", 
          RowBox[{"1.", " ", "\[Kappa]"}], ",", 
          RowBox[{"1.", " ", "Tep"}], ",", " ", "dir1"}], "}"}]}], "}"}], "//",
       "Transpose"}], "//", "TableForm"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"P", ",", 
      RowBox[{"FontColor", "\[Rule]", "Red"}], ",", 
      RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
      RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "=", 
   RowBox[{"R", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "3"}]]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Gamma]", "=", 
   RowBox[{"St", "/", 
    RowBox[{"(", 
     RowBox[{"ro", " ", "gr"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"vol", "=", 
   RowBox[{"vol", "/", 
    SuperscriptBox["m", "3"]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Heq", "=", 
    FractionBox["vol", 
     RowBox[{
      SuperscriptBox["R", "2"], " ", "\[Pi]"}]]}], ";"}], " ", 
  RowBox[{"(*", "  ", 
   RowBox[{"Volume", "-", 
    RowBox[{
    "equivalent", " ", "height", " ", "for", " ", "the", " ", "1", "D", " ", 
     "model", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"assuming", " ", "flat", " ", "fluid"}], "-", 
       RowBox[{"air", " ", "interface"}]}], ")"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Theta]", "=", 
    RowBox[{"\[Theta]", 
     FractionBox["\[Pi]", "180"]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"Vol", ",", "zz"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"BC", "<", "2"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Vol", "[", 
        RowBox[{"R_", ",", "z0_", ",", "\[Gamma]_"}], "]"}], ":=", 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox["R", "2"], " ", "z0", " ", 
        RowBox[{"Hypergeometric0F1Regularized", "[", 
         RowBox[{"2", ",", 
          FractionBox[
           SuperscriptBox["R", "2"], 
           RowBox[{"4", " ", "\[Gamma]"}]]}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", "z0", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"z0", "=", 
       RowBox[{
        RowBox[{"NSolve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Vol", "[", 
            RowBox[{"R", ",", "z0", ",", "\[Gamma]"}], "]"}], "==", "vol"}], 
          ",", "z0"}], "]"}], "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zz", "[", "r_", "]"}], ":=", 
       RowBox[{"z0", " ", 
        RowBox[{"BesselJ", "[", 
         RowBox[{"0", ",", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", "r"}], 
           SqrtBox["\[Gamma]"]]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
     ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Vol", "[", 
        RowBox[{"R_", ",", "\[Theta]_", ",", "\[Gamma]_"}], "]"}], ":=", 
       RowBox[{"2", " ", "\[Pi]", " ", "R", " ", "\[Gamma]", " ", 
        RowBox[{"Cot", "[", "\[Theta]", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", "h", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"h", "=", 
       FractionBox[
        RowBox[{"vol", "-", 
         RowBox[{"Vol", "[", 
          RowBox[{"R", ",", "\[Theta]", ",", "\[Gamma]"}], "]"}]}], 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox["R", "2"]}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"zz", "[", "r_", "]"}], ":=", 
       RowBox[{"h", "+", 
        FractionBox[
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["\[Gamma]"], " ", 
          RowBox[{"BesselJ", "[", 
           RowBox[{"0", ",", 
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", "r"}], 
             SqrtBox["\[Gamma]"]]}], "]"}], " ", 
          RowBox[{"Cot", "[", "\[Theta]", "]"}]}], 
         RowBox[{"BesselJ", "[", 
          RowBox[{"1", ",", 
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", "R"}], 
            SqrtBox["\[Gamma]"]]}], "]"}]]}]}], ";"}]}], 
    "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Z", "=", 
   RowBox[{"Interpolation", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"Chop", "[", 
          RowBox[{"zz", "[", "r", "]"}], "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "R", ",", 
         RowBox[{"R", "/", "99"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "zz", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"r", ",", "z"}], "]"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Construct", " ", "2", "D", " ", "cross"}], "-", 
    RowBox[{
    "sectional", " ", "mesh", " ", "for", " ", "solving", " ", "the", " ", 
     "3", "D", " ", "equation"}]}], " ", "*)"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalOmega]", "=", 
   RowBox[{"ImplicitRegion", "[", 
    RowBox[{
     RowBox[{"0", "\[LessEqual]", "z", "\[LessEqual]", 
      RowBox[{"Z", "[", "r", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ",", "0", ",", "R"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "0", ",", 
         RowBox[{"Z", "[", "R", "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mesh", "=", 
    RowBox[{"ToElementMesh", "[", 
     RowBox[{
      RowBox[{"DiscretizeRegion", "[", "\[CapitalOmega]", "]"}], ",", 
      RowBox[{"MaxCellMeasure", "\[Rule]", 
       SuperscriptBox["10", 
        RowBox[{"-", "8"}]]}]}], "]"}]}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"meshX", "=", 
    RowBox[{"ToElementMesh", "[", 
     RowBox[{
      RowBox[{"DiscretizeRegion", "[", "\[CapitalOmega]", "]"}], ",", 
      RowBox[{"MaxCellMeasure", "\[Rule]", "Automatic"}]}], "]"}]}], ";"}], 
  " ", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig2", "=", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"fig2a", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"Z", "[", "r", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "0", ",", "R"}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "R"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{
         "PlotLabel", "\[Rule]", "\"\<Well: half cross-sectional view\>\""}], 
         ",", "\[IndentingNewLine]", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", "Blue", "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", "\[IndentingNewLine]", 
         RowBox[{"FrameLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<r (m)\>\"", ",", "\"\<z (m)\>\""}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
         RowBox[{"FrameStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FrameTicks", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
         RowBox[{"GridLinesStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
         RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"ImageMargins", "\[Rule]", 
          RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], 
        "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"meshX", "[", 
       RowBox[{"\"\<Wireframe\>\"", "[", 
        RowBox[{"\"\<MeshElementStyle\>\"", "\[Rule]", 
         RowBox[{"EdgeForm", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Thickness", "[", "0.00001", "]"}], ",", "Blue"}], "}"}], 
          "]"}]}], "]"}], "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "meshX", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Sqrt]", 
       RowBox[{"(", 
        RowBox[{"x", "/", "v"}], ")"}]}], " ", "R"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "1", " ", ",", "v"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fig3", "=", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Circle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"X", "[", 
           RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "v"}], "}"}]}], "]"}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"5", " ", "cm"}]}]}], "]"}]}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Style", "[", 
     RowBox[{
     "\"\<Particle-transport variables are computed and well geometry and \
mesh are constructed. Computation begins.\>\"", ",", 
      RowBox[{"FontColor", "\[Rule]", "Red"}], ",", 
      RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
      RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", "u", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig4", "=", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Kappa]", " ", "u"}], ")"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"\[Kappa]", " ", "u"}]}], ")"}]}], ",", 
        RowBox[{"\[Kappa]", " ", "u"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"u", ",", "0", ",", 
        RowBox[{"c0", " ", 
         SuperscriptBox["10", "3"]}]}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"PlotLabel", "\[Rule]", "\"\<Hill-Langmuir model\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Gray", ",", 
         RowBox[{"{", 
          RowBox[{"Orange", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Particle concentration near cell surface (\[Mu]g/mL)\>\"", ",", 
         " ", "\"\<Neumann boundary value\>\""}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageMargins", "\[Rule]", 
       RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tlist", "=", 
    RowBox[{"Table", "[", 
     RowBox[{"i", ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "0", ",", "Tep", ",", "1"}], "}"}]}], "]"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"u1", ",", "t", ",", "x"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"op1", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], 
      RowBox[{"u1", "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "+", 
     RowBox[{"Sv", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{"u1", "[", 
        RowBox[{"t", ",", "x"}], "]"}]}]}], "-", 
     RowBox[{"Diff", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"u1", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}]}]}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Advection", "-", 
    RowBox[{
    "diffusion", " ", "equation", " ", "for", " ", "the", " ", "1", "D", " ", 
     "model"}]}], " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", " ", "=", 
   RowBox[{"tlist", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"u1", ",", "t", ",", "x", ",", "sol1Dirichlet"}], "]"}], ";"}], 
  "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"1", "D", " ", "solution", " ", "wiht", " ", "perfectly", " ", 
     RowBox[{"adsorbing", "/", "absorbing"}], " ", "bottom"}], ",", " ", 
    RowBox[{"Dirichlet", " ", "boundary"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol1Dirichlet", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"op1", "\[Equal]", "0"}], ",", 
         RowBox[{"DirichletCondition", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u1", "[", 
             RowBox[{"t", ",", "x"}], "]"}], "==", "0"}], ",", 
           RowBox[{"x", "\[Equal]", "0"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"u1", "[", 
           RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", " ", "c0"}]}], "}"}], 
       ",", "u1", ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"tmax", " ", "3600"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", " ", "Heq"}], " ", "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"u1", ",", "t", ",", "x", ",", "sol1"}], "]"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"1", "D", " ", "solution", " ", "wiht", " ", 
     RowBox[{"conc", ".", 
      RowBox[{"-", "dependent"}]}], " ", "affintify", " ", "for", " ", 
     RowBox[{"adsorption", "/", "absorption"}]}], ",", " ", 
    RowBox[{"Neumann", " ", "boundary"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol1", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"op1", "\[Equal]", 
          RowBox[{"NeumannValue", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Kappa]"}], " ", 
             RowBox[{"u1", "[", 
              RowBox[{"t", ",", "x"}], "]"}]}], ",", 
            RowBox[{"x", "\[Equal]", "0"}]}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"u1", "[", 
           RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", " ", "c0"}]}], "}"}], 
       ",", "u1", ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"tmax", " ", "3600"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "Heq"}], " ", "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"tlist", " ", "3600"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1Dirichlet", "=", 
   RowBox[{
    SuperscriptBox["10", "3"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"massTot", "/", "g"}], "-", " ", 
        RowBox[{
         SuperscriptBox["R", "2"], "\[Pi]", " ", 
         RowBox[{"NIntegrate", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"u1", "[", 
              RowBox[{"t", ",", "x"}], "]"}], "/.", "sol1Dirichlet"}], "]"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", " ", "Heq"}], "}"}]}], "]"}]}]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"D1Dirichlet", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Riffle", "[", 
       RowBox[{"tlist", ",", "d1Dirichlet"}], "]"}], ",", "2"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d1", "=", 
   RowBox[{
    SuperscriptBox["10", "3"], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"massTot", "/", "g"}], "-", " ", 
        RowBox[{
         SuperscriptBox["R", "2"], "\[Pi]", " ", 
         RowBox[{"NIntegrate", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{"u1", "[", 
              RowBox[{"t", ",", "x"}], "]"}], "/.", "sol1"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"x", ",", "0", ",", " ", "Heq"}], "}"}]}], "]"}]}]}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"D1", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Riffle", "[", 
       RowBox[{"tlist", ",", "d1"}], "]"}], ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig5", "=", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["10", "3"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"massTot", "/", "g"}], "/", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{
              SuperscriptBox["10", "3"], "1.05", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"massTot", "/", "g"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], 
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotLabel", "\[Rule]", "\"\<Solution of 1D model\>\""}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", "Gray"}], ",", "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Time (h)\>\"", ",", " ", 
           "\"\<Mass surface density (mg \!\(\*SuperscriptBox[\(m\), \
\(-2\)]\))\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicks", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
        RowBox[{"GridLinesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImageMargins", "\[Rule]", 
         RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}], 
      "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"D1Dirichlet", ",", "D1"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotMarkers", "\[Rule]", "None"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"{", 
            RowBox[{"Red", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", "ls"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"Placed", "[", 
          RowBox[{
           RowBox[{"LineLegend", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<1D Dirichlet\>\"", ",", "\"\<1D Neumann\>\""}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"LegendLayout", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<Column\>\"", ",", "1"}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"LegendFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"RoundingRadius", "\[Rule]", "0"}], ",", 
                  RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                  RowBox[{"Background", "\[Rule]", "White"}]}], "]"}], "&"}], 
               ")"}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.3", ",", "0.75"}], "}"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{"u1", ",", "t", ",", "x"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"op1", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], 
      RowBox[{"u1", "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "+", 
     RowBox[{"Sv", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{"u1", "[", 
        RowBox[{"t", ",", "x"}], "]"}]}]}], "-", 
     RowBox[{"Diff", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"u1", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}]}]}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Advection", "-", 
    RowBox[{
    "diffusion", " ", "equation", " ", "for", " ", "the", " ", "1", "D", " ", 
     "model"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"op1A", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], 
      RowBox[{"u1", "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], " ", "Sv", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{"u1", "[", 
        RowBox[{"t", ",", "x"}], "]"}]}]}], "-", 
     RowBox[{"Diff", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"u1", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}]}]}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Advection", "-", 
    RowBox[{
    "diffusion", " ", "equation", " ", "for", " ", "the", " ", "1", "D", " ", 
     "model"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"op1B", "=", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], 
      RowBox[{"u1", "[", 
       RowBox[{"t", ",", "x"}], "]"}]}], "+", 
     RowBox[{"Sv", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{"u1", "[", 
        RowBox[{"t", ",", "x"}], "]"}]}]}], "-", 
     RowBox[{
      SuperscriptBox["10", 
       RowBox[{"-", "6"}]], " ", "Diff", " ", 
      RowBox[{
       SubscriptBox["\[PartialD]", "x"], 
       RowBox[{
        SubscriptBox["\[PartialD]", "x"], 
        RowBox[{"u1", "[", 
         RowBox[{"t", ",", "x"}], "]"}]}]}]}]}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"Advection", "-", 
    RowBox[{
    "diffusion", " ", "equation", " ", "for", " ", "the", " ", "1", "D", " ", 
     "model"}]}], " ", "*)"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmax", " ", "=", 
   RowBox[{"tlist", "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"u1", ",", "t", ",", "x", ",", "sol1Dirichlet"}], "]"}], ";"}], 
  "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"1", "D", " ", "solution", " ", "wiht", " ", "perfectly", " ", 
     RowBox[{"adsorbing", "/", "absorbing"}], " ", "bottom"}], ",", " ", 
    RowBox[{"Dirichlet", " ", "boundary"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1D", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"op1", "\[Equal]", "0"}], ",", 
        RowBox[{"DirichletCondition", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"u1", "[", 
            RowBox[{"t", ",", "x"}], "]"}], "==", "0"}], ",", 
          RowBox[{"x", "\[Equal]", "0"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"u1", "[", 
          RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", " ", "c0"}]}], "}"}], 
      ",", "u1", ",", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"tmax", " ", "3600"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", " ", "Heq"}], " ", "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"u1", ",", "t", ",", "x", ",", "sol1Dirichlet"}], "]"}], ";"}], 
  "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"1", "D", " ", "solution", " ", "wiht", " ", "perfectly", " ", 
     RowBox[{"adsorbing", "/", "absorbing"}], " ", "bottom"}], ",", " ", 
    RowBox[{"Dirichlet", " ", "boundary"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sol1DA", "=", 
   RowBox[{
    RowBox[{"NDSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"op1A", "\[Equal]", "0"}], ",", 
        RowBox[{"DirichletCondition", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"u1", "[", 
            RowBox[{"t", ",", "x"}], "]"}], "==", "0"}], ",", 
          RowBox[{"x", "\[Equal]", "0"}]}], "]"}], ",", 
        RowBox[{
         RowBox[{"u1", "[", 
          RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", " ", "c0"}]}], "}"}], 
      ",", "u1", ",", " ", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", 
        RowBox[{"tmax", " ", "3600"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", " ", "Heq"}], " ", "}"}]}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"u1", ",", "t", ",", "x", ",", "sol1Dirichlet"}], "]"}], ";"}], 
  "  ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"1", "D", " ", "solution", " ", "wiht", " ", "perfectly", " ", 
     RowBox[{"adsorbing", "/", "absorbing"}], " ", "bottom"}], ",", " ", 
    RowBox[{"Dirichlet", " ", "boundary"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol1DB", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"op1B", "\[Equal]", "0"}], ",", 
         RowBox[{"DirichletCondition", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"u1", "[", 
             RowBox[{"t", ",", "x"}], "]"}], "==", "0"}], ",", 
           RowBox[{"x", "\[Equal]", "0"}]}], "]"}], ",", 
         RowBox[{
          RowBox[{"u1", "[", 
           RowBox[{"0", ",", "x"}], "]"}], "\[Equal]", " ", "c0"}]}], "}"}], 
       ",", "u1", ",", " ", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", 
         RowBox[{"tmax", " ", "3600"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", " ", "Heq"}], " ", "}"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"tlist", " ", "3600"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AB", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Riffle", "[", 
      RowBox[{"tlist", ",", 
       RowBox[{
        SuperscriptBox["10", "3"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"massTot", "/", "g"}], "-", " ", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]", " ", 
             RowBox[{"NIntegrate", "[", 
              RowBox[{
               RowBox[{"Evaluate", "[", 
                RowBox[{
                 RowBox[{"u1", "[", 
                  RowBox[{"t", ",", "x"}], "]"}], "/.", "sol1D"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "0", ",", " ", "Heq"}], "}"}]}], "]"}]}]}], 
           ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], "]"}], 
     ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Riffle", "[", 
      RowBox[{"tlist", ",", 
       RowBox[{
        SuperscriptBox["10", "3"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"massTot", "/", "g"}], "-", " ", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]", " ", 
             RowBox[{"NIntegrate", "[", 
              RowBox[{
               RowBox[{"Evaluate", "[", 
                RowBox[{
                 RowBox[{"u1", "[", 
                  RowBox[{"t", ",", "x"}], "]"}], "/.", "sol1DA"}], "]"}], 
               ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "0", ",", " ", "Heq"}], "}"}]}], "]"}]}]}], 
           ")"}], "/", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], "]"}], 
     ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"B", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Riffle", "[", 
       RowBox[{"tlist", ",", 
        RowBox[{
         SuperscriptBox["10", "3"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"massTot", "/", "g"}], "-", " ", 
             RowBox[{
              SuperscriptBox["R", "2"], "\[Pi]", " ", 
              RowBox[{"NIntegrate", "[", 
               RowBox[{
                RowBox[{"Evaluate", "[", 
                 RowBox[{
                  RowBox[{"u1", "[", 
                   RowBox[{"t", ",", "x"}], "]"}], "/.", "sol1DB"}], "]"}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"x", ",", "0", ",", " ", "Heq"}], "}"}]}], "]"}]}]}],
             ")"}], "/", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], "]"}], 
      ",", "2"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig6", "=", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["10", "3"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"massTot", "/", "g"}], "/", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", "tmax"}], "}"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{
              SuperscriptBox["10", "3"], "1.05", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"massTot", "/", "g"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], 
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
        "PlotLabel", "\[Rule]", 
         "\"\<Solution of 1D model / Dirichlet boundary\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", "Gray"}], ",", "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Time (h)\>\"", ",", " ", 
           "\"\<Mass surface density (mg \!\(\*SuperscriptBox[\(m\), \
\(-2\)]\))\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicks", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
        RowBox[{"GridLinesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImageMargins", "\[Rule]", 
         RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}], 
      "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"AB", ",", "A", ",", "B"}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotMarkers", "\[Rule]", "None"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", 
           RowBox[{"{", 
            RowBox[{"Red", ",", "Dashed"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Blue", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", "ls"}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"Placed", "[", 
          RowBox[{
           RowBox[{"LineLegend", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
              "\"\<Diffusion & Settling\>\"", ",", "\"\<Diffusion only\>\"", 
               ",", "\"\<Settling only\>\""}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"LegendLayout", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<Column\>\"", ",", "1"}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"LegendFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"RoundingRadius", "\[Rule]", "0"}], ",", 
                  RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                  RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], "&"}], 
               ")"}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.5", ",", "0.75"}], "}"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"\"\<1D model is ready. Computing the 3D model begins.\>\"", ",", 
      RowBox[{"FontColor", "\[Rule]", "Red"}], ",", 
      RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
      RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"u", ",", "t", ",", "r", ",", "z"}], "]"}], ";"}], "  ", 
  RowBox[{"(*", " ", 
   RowBox[{"Advection", "-", 
    RowBox[{
    "diffusion", " ", "equation", " ", "for", " ", "the", " ", "3", "D", " ", 
     "model"}]}], " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"op", " ", "=", " ", 
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "t"], 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "r", ",", "z"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"Inactive", "[", "Div", "]"}], "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Inactive", "[", "Plus", "]"}], "[", 
        RowBox[{
         RowBox[{"Times", "[", 
          RowBox[{"Diff", ",", 
           RowBox[{
            RowBox[{"Inactive", "[", "Grad", "]"}], "[", 
            RowBox[{
             RowBox[{"u", "[", 
              RowBox[{"t", ",", " ", "r", ",", " ", "z"}], "]"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{"r", ",", " ", "z"}], "}"}]}], "]"}]}], "]"}], ",", 
         RowBox[{"Times", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", " ", "Sv"}], "}"}], ",", " ", 
           RowBox[{"u", "[", 
            RowBox[{"t", ",", " ", "r", ",", " ", "z"}], "]"}]}], "]"}]}], 
        "]"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"r", ",", " ", "z"}], "}"}]}], "]"}], "-", 
     RowBox[{"1", "*", 
      RowBox[{"(", 
       RowBox[{"1", "/", "r"}], ")"}], 
      RowBox[{
       SubscriptBox["\[PartialD]", "r"], " ", "Diff"}], " ", 
      RowBox[{"u", "[", 
       RowBox[{"t", ",", "r", ",", "z"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "Computes", " ", "particle", " ", "concentration", " ", "in", " ", 
    "well"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"sol", "=", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"op", "\[Equal]", 
          RowBox[{"NeumannValue", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "\[Kappa]"}], " ", 
             RowBox[{"u", "[", 
              RowBox[{"t", ",", "r", ",", "z"}], "]"}]}], ",", 
            RowBox[{"z", "\[Equal]", "0"}]}], "]"}]}], ",", 
         RowBox[{
          RowBox[{"u", "[", 
           RowBox[{"0", ",", "r", ",", "z"}], "]"}], "\[Equal]", "c0"}]}], 
        "}"}], ",", 
       RowBox[{"u", "[", 
        RowBox[{"t", ",", " ", "r", ",", " ", "z"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", " ", 
         RowBox[{"3600", "tmax"}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"r", ",", "z"}], "}"}], "\[Element]", "mesh"}], ",", 
       RowBox[{"Method", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<PDEDiscretization\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<MethodOfLines\>\"", ",", 
            RowBox[{"\"\<SpatialDiscretization\>\"", "\[Rule]", 
             RowBox[{"{", "\"\<FiniteElement\>\"", "}"}]}]}], "}"}]}], 
         "}"}]}], ",", 
       RowBox[{"InterpolationOrder", "\[Rule]", "Automatic"}]}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"figx", ",", "figy", ",", "figz"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"j", "=", "1"}], ";", 
  RowBox[{"ProgressIndicator", "[", 
   RowBox[{
    RowBox[{"Dynamic", "[", "j", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"Length", "[", "tlist", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"j", "\[LessEqual]", 
     RowBox[{"Length", "[", "tlist", "]"}]}], ",", "\[IndentingNewLine]", 
    "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"t", "=", 
      RowBox[{
       RowBox[{"tlist", "[", 
        RowBox[{"[", "j", "]"}], "]"}], " ", "3600"}]}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{"j", ">", "1"}], ",", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{
         RowBox[{"figx", "[", "j", "]"}], "=", 
         RowBox[{"Plot3D", "[", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{"Log", "[", 
             RowBox[{"10", ",", 
              RowBox[{
               RowBox[{"u", "[", 
                RowBox[{"t", ",", "r", ",", "z"}], "]"}], "/.", "sol"}]}], 
             "]"}], "]"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"r", ",", "z"}], "}"}], "\[Element]", "mesh"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"PlotLabel", "\[Rule]", 
            RowBox[{"\"\<Time: \>\"", "<>", 
             RowBox[{"ToString", "[", 
              RowBox[{"Round", "[", 
               RowBox[{"N", "[", 
                RowBox[{"t", "/", "3600"}], " ", "]"}], "]"}], "]"}], "<>", 
             "\"\< h\>\""}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"PlotRange", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"0", ",", "All"}], "}"}]}], ",", 
           RowBox[{"(*", "c0", "*)"}], "\[IndentingNewLine]", 
           RowBox[{"AxesLabel", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
             "\"\<r (m)\>\"", ",", "\"\<z (m)\>\"", ",", 
              "\"\<c (\[Mu]g \!\(\*SuperscriptBox[\(mL\), \(-1\)]\))\>\""}], 
             "}"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"LabelStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"FontColor", "\[Rule]", "Black"}], ",", 
              RowBox[{"FontWeight", "\[Rule]", "\"\<Light\>\""}], ",", 
              RowBox[{"FontFamily", "\[Rule]", "\"\<Arial Narrow\>\""}], ",", 
              RowBox[{"FontSize", "\[Rule]", "7"}]}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{"ImageSize", "\[Rule]", 
              RowBox[{"2", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"R", "  ", 
                  SuperscriptBox["10", "3"], "cm"}], ",", 
                 RowBox[{
                  RowBox[{"Z", "[", "R", "]"}], " ", 
                  SuperscriptBox["10", "3"], "cm"}]}], "}"}]}]}], ","}], 
            "*)"}], "\[IndentingNewLine]", 
           RowBox[{"ImageSize", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"ImageMargins", "\[Rule]", 
            RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
           RowBox[{"BoxRatios", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"R", ",", 
              RowBox[{"Z", "[", "R", "]"}], ",", 
              RowBox[{"0.4", " ", "R"}]}], "}"}]}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
           "ColorFunction", "\[Rule]", " ", "\"\<TemperatureMap\>\""}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"BoxStyle", "\[Rule]", "fs"}]}], "\[IndentingNewLine]", 
          "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"figy", "[", "j", "]"}], "=", 
         RowBox[{"Show", "[", "\[IndentingNewLine]", 
          RowBox[{"fig2a", "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
           RowBox[{"DensityPlot", "[", 
            RowBox[{
             RowBox[{"Evaluate", "[", 
              RowBox[{"Log", "[", 
               RowBox[{"10", ",", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"t", ",", "r", ",", "z"}], "]"}], "/.", "sol"}]}], 
               "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"r", ",", "z"}], "}"}], "\[Element]", "mesh"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"(*", 
              RowBox[{
               RowBox[{"PlotLabel", "\[Rule]", 
                RowBox[{"\"\<Time: \>\"", "<>", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Round", "[", 
                   RowBox[{"N", "[", 
                    RowBox[{"t", "/", "3600"}], " ", "]"}], "]"}], "]"}], 
                 "<>", "\"\< h\>\""}]}], ","}], "*)"}], "\[IndentingNewLine]", 
             RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
             RowBox[{"(*", " ", "c0", " ", "*)"}], "\[IndentingNewLine]", 
             RowBox[{"FrameLabel", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
               "\"\<r (m)\>\"", ",", "\"\<z (m)\>\"", ",", 
                "\"\<\!\(\*SubscriptBox[\(Log\), \(10\)]\) c (\[Mu]g \
\!\(\*SuperscriptBox[\(mL\), \(-1\)]\))\>\""}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"LabelStyle", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"FontColor", "\[Rule]", "Black"}], ",", 
                RowBox[{"FontWeight", "\[Rule]", "\"\<Light\>\""}], ",", 
                RowBox[{"FontFamily", "\[Rule]", "\"\<Arial Narrow\>\""}], 
                ",", 
                RowBox[{"FontSize", "\[Rule]", "12"}]}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{
             "ColorFunction", "\[Rule]", " ", "\"\<TemperatureMap\>\""}], ",",
              "\[IndentingNewLine]", 
             RowBox[{"PlotLegends", "\[Rule]", "None"}]}], 
            "\[IndentingNewLine]", "]"}]}], "\[IndentingNewLine]", "]"}]}], 
        ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        RowBox[{"Export", "[", 
         RowBox[{
          RowBox[{"\"\<fig_\>\"", "<>", 
           RowBox[{"ToString", "[", 
            RowBox[{"tlist", "[", 
             RowBox[{"[", "j", "]"}], "]"}], " ", "]"}], "<>", 
           "\"\<h.gif\>\""}], ",", 
          RowBox[{"GraphicsRow", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"figx", "[", "j", "]"}], ",", 
              RowBox[{"figy", "[", "j", "]"}]}], "}"}], ",", 
            RowBox[{"ImageSize", "->", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"2", "sx"}], ",", " ", "sy"}], "}"}]}]}], "]"}], ",", 
          RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ";", 
     "\[IndentingNewLine]", "\[IndentingNewLine]", 
     RowBox[{"j", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", "j", "]"}], ";"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Computes", " ", "total", " ", "dose"}], ",", " ", 
    RowBox[{"metric", ":", " ", 
     RowBox[{
      RowBox[{"mass", " ", "/", " ", "surface"}], " ", "area"}]}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D3", "=", 
   RowBox[{"{", "}"}]}], ";", " ", 
  RowBox[{"ProgressIndicator", "[", 
   RowBox[{
    RowBox[{"Dynamic", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"Length", "[", "tlist", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"i", "=", "1"}], ";", 
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"i", "\[LessEqual]", 
      RowBox[{"Length", "[", "tlist", "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"t", "=", 
       RowBox[{
        RowBox[{"tlist", "[", 
         RowBox[{"[", "i", "]"}], "]"}], " ", "3600"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"r", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"r", "\[LessEqual]", "R"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Zr", "=", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"z", ",", 
              RowBox[{"2", " ", "r", " ", "\[Pi]", " ", 
               RowBox[{"Evaluate", "[", 
                RowBox[{
                 RowBox[{"u", "[", 
                  RowBox[{"t", ",", "r", ",", "z"}], "]"}], "/.", "sol"}], 
                "]"}]}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"z", ",", "0", ",", 
              RowBox[{"Z", "[", "r", "]"}], ",", 
              RowBox[{"0.005", " ", 
               RowBox[{"Z", "[", "r", "]"}]}]}], "}"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"ipZr", "=", 
          RowBox[{"Interpolation", "[", 
           RowBox[{"Zr", ",", 
            RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"AppendTo", "[", 
          RowBox[{"Q", ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", 
             RowBox[{"NIntegrate", "[", 
              RowBox[{
               RowBox[{"ipZr", "[", "z", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"z", ",", "0", ",", 
                 RowBox[{"Z", "[", "r", "]"}]}], "}"}]}], "]"}]}], "}"}]}], 
          "]"}], ";", "\[IndentingNewLine]", 
         RowBox[{"r", "+=", 
          RowBox[{"0.025", "R"}]}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ip", "=", 
       RowBox[{"Interpolation", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"InterpolationOrder", "\[Rule]", "2"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"D3", ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t", "/", "3600"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"massTot", "/", "g"}], "-", 
             RowBox[{"NIntegrate", "[", 
              RowBox[{
               RowBox[{"ip", "[", "r", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"r", ",", "0", ",", "R"}], "}"}]}], "]"}]}], ")"}], 
           "/", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}]}], "}"}]}], "]"}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"i", "++"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Clear", "[", 
    RowBox[{"Q", ",", "ip", ",", "Zr", ",", "ipZr"}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mD3", "=", "D3"}], ";", " ", 
   RowBox[{
    RowBox[{"mD3", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "2"}], "]"}], "]"}], "=", 
    RowBox[{
     SuperscriptBox["10", "3"], 
     RowBox[{"D3", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "2"}], "]"}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig7", "=", "\[IndentingNewLine]", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"mD3", ",", "D1"}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{
              SuperscriptBox["10", "3"], "1.05", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"massTot", "/", "g"}], "/", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}]}], 
            "}"}]}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{
        "PlotLabel", "\[Rule]", "\"\<Solution of 1D and 3D models\>\""}], ",",
         "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"RGBColor", "[", 
            RowBox[{"0.2", ",", "0.7", ",", "1"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"Red", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotMarkers", "\[Rule]", "Automatic"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Time (h)\>\"", ",", " ", 
           "\"\<Mass surface density (mg \!\(\*SuperscriptBox[\(m\), \
\(-2\)]\))\>\""}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicks", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
        RowBox[{"GridLinesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImageMargins", "\[Rule]", 
         RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"sy", "/", "sx"}]}], "\[IndentingNewLine]", ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"Placed", "[", 
          RowBox[{
           RowBox[{"LineLegend", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"\"\<3D-model\>\"", ",", "\"\<1D-model\>\""}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"LegendLayout", "\[Rule]", 
              RowBox[{"{", 
               RowBox[{"\"\<Column\>\"", ",", "1"}], "}"}]}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"LegendFunction", "\[Rule]", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Framed", "[", 
                 RowBox[{"#", ",", 
                  RowBox[{"RoundingRadius", "\[Rule]", "0"}], ",", 
                  RowBox[{"FrameStyle", "\[Rule]", "None"}], ",", 
                  RowBox[{"Background", "\[Rule]", "None"}]}], "]"}], "&"}], 
               ")"}]}]}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.3", ",", "0.75"}], "}"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["10", "3"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"massTot", "/", "g"}], "/", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]"}], ")"}]}], ")"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"tmax", "+", "1"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Dashed", ",", "Black"}], "}"}]}]}], "]"}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"Clear", "[", "t", "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Computes", " ", "total", " ", 
    RowBox[{"mass", " ", "/", " ", "g"}]}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ipM", " ", "=", 
    RowBox[{"Interpolation", "[", 
     RowBox[{
      RowBox[{"Partition", "[", 
       RowBox[{
        RowBox[{"Riffle", "[", " ", 
         RowBox[{
          RowBox[{"D3", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "1"}], "]"}], "]"}], ",", 
          RowBox[{
           SuperscriptBox["R", "2"], "\[Pi]", " ", 
           RowBox[{"D3", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "2"}], "]"}], "]"}]}]}], "]"}], ",", "2"}], 
       "]"}], ",", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["10", "6"], 
      RowBox[{"ipM", " ", "[", "t", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", 
       RowBox[{"D3", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"D3", "[", 
        RowBox[{"[", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "All"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{
           RowBox[{"massTot", "/", "g"}], " ", 
           SuperscriptBox["10", "6"]}]}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Time (h)\>\"", ",", " ", "\"\<m (\[Mu]g)\>\""}], " ", 
       "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", "\[IndentingNewLine]", 
     RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImageMargins", "\[Rule]", 
      RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[CapitalDelta]j", "=", "0.1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"L", "=", 
    RowBox[{"tmax", "/", "\[CapitalDelta]j"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", "=", "1"}], ";", " ", 
  RowBox[{"\[CapitalDelta]M", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"l", "\[LessEqual]", "L"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"\[CapitalDelta]M", ",", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"ipM", "[", 
           RowBox[{"l", " ", "\[CapitalDelta]j"}], " ", "]"}], "-", 
          RowBox[{"ipM", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"l", "-", "1"}], ")"}], " ", "\[CapitalDelta]j"}], " ", 
           "]"}]}], ")"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"l", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], "\n",
   "\n", 
  RowBox[{"(*", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"\[CapitalDelta]M", ",", "\[IndentingNewLine]", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "All"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"Gray", ",", "Thin"}], "}"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"PlotMarkers", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<OpenMarkers\>\"", ",", "5"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Time (h)\>\"", ",", " ", 
        "\"\<dm (t-\[CapitalDelta]t,t) (g)\>\""}], "   ", "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FrameStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", "\[IndentingNewLine]", 
     RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
     RowBox[{"GridLinesStyle", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"ImageMargins", "\[Rule]", 
      RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{"AspectRatio", "\[Rule]", 
      RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}], 
   "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", "=", "1"}], ";", 
  RowBox[{"Clear", "[", "\[Gamma]m", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"l", "\[LessEqual]", "L"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"t", "=", 
       RowBox[{"l", " ", "\[CapitalDelta]j", " ", "3600"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalGamma]", "=", 
       RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Clear", "[", "r", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"z", "=", "0"}], ";", "\[IndentingNewLine]", 
      RowBox[{"AppendTo", "[", 
       RowBox[{"\[CapitalGamma]", ",", 
        RowBox[{"Mean", "[", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Evaluate", "[", 
             RowBox[{"u", "[", 
              RowBox[{"t", ",", "r", ",", "z"}], "]"}], "]"}], "/.", "sol"}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"r", ",", "0", " ", ",", 
             RowBox[{"X", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{
              RowBox[{"X", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "/", "10"}]}], "}"}]}], "]"}], 
         "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"i", "=", "2"}], ";", "\[IndentingNewLine]", 
      RowBox[{"While", "[", 
       RowBox[{
        RowBox[{"i", "\[LessEqual]", "v"}], ",", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"AppendTo", "[", 
          RowBox[{"\[CapitalGamma]", ",", 
           RowBox[{"Mean", "[", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Evaluate", "[", 
                RowBox[{"u", "[", 
                 RowBox[{"t", ",", "r", ",", "z"}], "]"}], "]"}], "/.", 
               "sol"}], ",", 
              RowBox[{"{", 
               RowBox[{"r", ",", 
                RowBox[{"X", "[", 
                 RowBox[{"[", 
                  RowBox[{"i", "-", "1"}], "]"}], "]"}], " ", ",", 
                RowBox[{"X", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"X", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "-", 
                   RowBox[{"X", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", "-", "1"}], "]"}], "]"}]}], ")"}], "/", 
                 "10"}]}], "}"}]}], "]"}], "]"}]}], "]"}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"i", "++"}]}]}], "\[IndentingNewLine]", "]"}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"\[CapitalDelta]M", "=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"ipM", "[", 
          RowBox[{"l", " ", "\[CapitalDelta]j"}], " ", "]"}], "-", 
         RowBox[{"ipM", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"l", "-", "1"}], ")"}], " ", "\[CapitalDelta]j"}], " ", 
          "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Gamma]m", "[", "l", "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"\[CapitalDelta]M", "/", 
          RowBox[{"Total", "[", "\[CapitalGamma]", "]"}]}], ")"}], 
        "\[CapitalGamma]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"l", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"ps", "=", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{"Riffle", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{"Thin", ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "L"}], "}"}]}], "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"RGBColor", "[", 
           RowBox[{"i", ",", "0.25", ",", "0.85"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "1", ",", 
            RowBox[{"1", "/", 
             RowBox[{"(", 
              RowBox[{"L", "-", "1"}], ")"}]}]}], "}"}]}], "]"}]}], "]"}], 
      ",", "2"}], "]"}]}], ";"}], "\[IndentingNewLine]", "\n", 
  RowBox[{"(*", 
   RowBox[{"fig6", "=", 
    RowBox[{"ListLogPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"\[Gamma]m", "[", "l", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"l", ",", "L"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "-", 
            RowBox[{"0.1", " ", "v"}]}], ",", 
           RowBox[{"1.1", "v"}]}], "}"}], ",", "All"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", "ps"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{"\"\<OpenMarkers\>\"", ",", "3"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Area\>\"", ",", " ", "\"\<dm (g)\>\""}], "   ", "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "v"}], "}"}]}], "]"}], ",", "None"}], "}"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageMargins", "\[Rule]", 
       RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"l", "=", "1"}], ";", 
  RowBox[{"Clear", "[", "\[Delta]\[Mu]", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"l", "\[LessEqual]", "L"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"s", "=", 
       RowBox[{"Total", "[", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"\[Gamma]m", "[", "y", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"y", ",", "l"}], "}"}]}], "]"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "=", "s"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"l", "++"}], ";"}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"fig7", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"l", ",", "L"}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "-", 
            RowBox[{"0.1", " ", "v"}]}], ",", 
           RowBox[{"1.1", "v"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", "ps"}], ",", "\[IndentingNewLine]", 
      RowBox[{"PlotMarkers", "\[Rule]", " ", 
       RowBox[{"{", 
        RowBox[{"\"\<OpenMarkers\>\"", ",", "3"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<Area\>\"", ",", " ", "\"\<m (g)\>\""}], "   ", "}"}]}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "v"}], "}"}]}], "]"}], ",", "None"}], "}"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageMargins", "\[Rule]", 
       RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"sy", "/", "sx"}]}]}], "\[IndentingNewLine]", "]"}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig8", "=", 
    RowBox[{"ListLinePlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox["10", "3"], 
         RowBox[{"(", 
          RowBox[{"v", "/", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["R", "2"], "\[Pi]"}], " ", ")"}]}], ")"}], 
         RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"l", ",", "1", ",", "L", ",", "10"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<Mass density averaged over the annuli\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "-", 
            RowBox[{"0.1", " ", "v"}]}], ",", 
           RowBox[{"1.1", "v"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Annulus\>\"", ",", " ", 
         "\"\<M (mg \!\(\*SuperscriptBox[\(m\), \(-2\)]\))\>\""}], "   ", 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Table", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "v"}], "}"}]}], "]"}], ",", "None"}], "}"}]}],
         "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageMargins", "\[Rule]", 
       RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"sy", "/", "sx"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ColorFunction", "\[Rule]", " ", "\"\<TemperatureMap\>\""}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig9", "=", 
    RowBox[{"Show", "[", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Mean", "[", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["R", "2"], 
                  RowBox[{"\[Pi]", "/", "v"}]}], " ", ")"}]}], ")"}], 
              SuperscriptBox["10", "3"], 
              RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}]}], "]"}], ",", 
            RowBox[{"100", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
                  RowBox[{"[", 
                   RowBox[{"-", "1"}], "]"}], "]"}], "-", 
                 RowBox[{
                  RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", 
               RowBox[{
                RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "L"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{
        "PlotLabel", "\[Rule]", 
         "\"\<Relative mass density difference on the annuli\>\""}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "All"}], "}"}], ",", "All"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Thickness", "[", "0.02", "]"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotMarkers", "\[Rule]", "None"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<M (mg \!\(\*SuperscriptBox[\(m\), \(-2\)]\))\>\"", ",", " ", 
           "\"\<\!\(\*SubscriptBox[\(\[CapitalDelta]\), \(M\)]\) (%)\>\""}], 
          "   ", "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
        RowBox[{"FrameStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicks", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
        RowBox[{"GridLinesStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ImageMargins", "\[Rule]", 
         RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"AspectRatio", "\[Rule]", 
         RowBox[{"sy", "/", "sx"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"ColorFunction", "\[Rule]", " ", "\"\<TemperatureMap\>\""}]}],
        "\[IndentingNewLine]", "]"}], "\[IndentingNewLine]", ",", 
      "\[IndentingNewLine]", 
      RowBox[{"ListLinePlot", "[", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Mean", "[", 
             RowBox[{
              SuperscriptBox["10", "3"], 
              RowBox[{"(", 
               RowBox[{"1", "/", 
                RowBox[{"(", 
                 RowBox[{
                  SuperscriptBox["R", "2"], 
                  RowBox[{"\[Pi]", "/", "v"}]}], " ", ")"}]}], ")"}], 
              RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}]}], "]"}], ",", 
            RowBox[{"100", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
                  RowBox[{"[", 
                   RowBox[{"-", "1"}], "]"}], "]"}], "-", 
                 RowBox[{
                  RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", 
               RowBox[{
                RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"l", ",", "1", ",", "L"}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotStyle", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"Black", ",", "Thin", ",", "Dashed"}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "\[IndentingNewLine]", 
       "]"}]}], "\[IndentingNewLine]", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<3D model is ready. Saving the results begins.\>\"", ",", 
     RowBox[{"FontColor", "\[Rule]", "Red"}], ",", 
     RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
     RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"SystemOpen", "[", "dir1", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Chi]", "=", "3."}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"D1", "=", 
   RowBox[{"1.", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "\[Chi]"}]], 
    RowBox[{"Floor", "[", 
     RowBox[{
      SuperscriptBox["10", "\[Chi]"], " ", "D1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mD3", "=", 
   RowBox[{"1.", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "\[Chi]"}]], 
    RowBox[{"Floor", "[", 
     RowBox[{
      SuperscriptBox["10", "\[Chi]"], " ", "mD3"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"D1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "1"}], "]"}], "]"}], ",", 
       RowBox[{"D1", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}], ",", 
       RowBox[{"mD3", "[", 
        RowBox[{"[", 
         RowBox[{"i", ",", "2"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", 
       RowBox[{"Length", "[", "D1", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Total_dose.csv\>\"", ",", 
   RowBox[{"N", "[", "p1", "]"}], ",", "\"\<CSV\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"PrependTo", "[", 
    RowBox[{"p1", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Time (h)\>\"", ",", 
       "\"\<1D (mg \!\(\*SuperscriptBox[\(m\), \(-2\)]\))\>\"", ",", 
       "\"\<3D (mg \!\(\*SuperscriptBox[\(m\), \(-2\)]\))\>\""}], "}"}]}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<Total_dose.pdf\>\"", ",", 
     RowBox[{
      RowBox[{"N", "[", "p1", "]"}], "//", "TableForm"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m1", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"tlist", "[", 
      RowBox[{"[", "i", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "2", ",", 
       RowBox[{"Length", "[", "tlist", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m2", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      SuperscriptBox["10", "3"], 
      RowBox[{"(", 
       RowBox[{"v", "/", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["R", "2"], "\[Pi]"}], " ", ")"}]}], ")"}], 
      RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"l", ",", "1", ",", "L", ",", "10"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"m", ",", "m1"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"i", "<=", "v"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"AppendTo", "[", 
       RowBox[{"m", ",", 
        RowBox[{"m2", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "i"}], "]"}], "]"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"i", "++"}]}]}], "\[IndentingNewLine]", "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"fig10", "=", 
    RowBox[{"ListPlot", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Partition", "[", 
         RowBox[{
          RowBox[{"Riffle", "[", 
           RowBox[{
            RowBox[{"m", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", ";;"}], "]"}], "]"}], ",", 
            RowBox[{"m", "[", 
             RowBox[{"[", 
              RowBox[{
               RowBox[{"i", "+", "1"}], ",", ";;"}], "]"}], "]"}]}], "]"}], 
          ",", "2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "1", ",", "v"}], "}"}]}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
      "PlotLabel", "\[Rule]", 
       "\"\<Mass density averaged over the annuli vs time\>\""}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "All"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Joined", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"InterpolationOrder", "\[Rule]", "1"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
        "\"\<Time (h)\>\"", ",", " ", 
         "\"\<M (mg \!\(\*SuperscriptBox[\(m\), \(-2\)]\))\>\""}], "   ", 
        "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", "\[IndentingNewLine]", 
      RowBox[{"FrameStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"fs", ",", "fs", ",", "fs", ",", "fs"}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Automatic", ",", "None"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"FrameTicksStyle", "\[Rule]", "th"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"GridLines", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
      RowBox[{"GridLinesStyle", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"th", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"LabelStyle", "\[Rule]", "ls"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImagePadding", "\[Rule]", "Full"}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"sx", ",", "sy"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ImageMargins", "\[Rule]", 
       RowBox[{"0.", " ", "cm"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"sy", "/", "sx"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"ColorFunction", "\[Rule]", " ", "Automatic"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "\[IndentingNewLine]", 
     "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"1.", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "\[Chi]"}]], 
    RowBox[{"Floor", "[", 
     RowBox[{
      SuperscriptBox["10", "\[Chi]"], " ", "m"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"m", "//", "Transpose"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "//", "TableForm"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Dose_on_annuli.csv\>\"", ",", 
    RowBox[{"N", "[", "m", "]"}], ",", "\"\<CSV\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{
    RowBox[{"PrependTo", "[", 
     RowBox[{"m", ",", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\"\<Time (h)\>\"", ",", 
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"\"\<Annulus \>\"", "<>", 
            RowBox[{"ToString", "[", "i", "]"}], "<>", 
            "\"\< (mg \!\(\*SuperscriptBox[\(m\), \(-2\)]\))\>\""}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "v"}], "}"}]}], "]"}]}], "}"}], "//", 
       "Flatten"}]}], "]"}], "//", "TableForm"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<Dose_on_annuli.pdf\>\"", ",", 
     RowBox[{"N", "[", "m", "]"}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Mean", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["R", "2"], 
              RowBox[{"\[Pi]", "/", "v"}]}], " ", ")"}]}], ")"}], 
          SuperscriptBox["10", "3"], 
          RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}]}], "]"}], ",", 
        RowBox[{"100", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
              RowBox[{"[", 
               RowBox[{"-", "1"}], "]"}], "]"}], "-", 
             RowBox[{
              RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", 
           RowBox[{
            RowBox[{"\[Delta]\[Mu]", "[", "l", "]"}], "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l", ",", "1", ",", "L", ",", "10"}], "}"}]}], "]"}], "//", 
    "Abs"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"1.", " ", 
    SuperscriptBox["10", 
     RowBox[{"-", "\[Chi]"}]], 
    RowBox[{"Floor", "[", 
     RowBox[{
      SuperscriptBox["10", "\[Chi]"], " ", "p1"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Dose_bias.csv\>\"", ",", 
    RowBox[{"N", "[", "p1", "]"}], ",", "\"\<CSV\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"PrependTo", "[", 
    RowBox[{"p1", ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Total dose 3D (mg \!\(\*SuperscriptBox[\(m\), \(-2\)]\))\>\"", 
       ",", "\"\<Rel. diff. %\>\""}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{"\"\<Dose_bias.pdf\>\"", ",", 
    RowBox[{
     RowBox[{"N", "[", "p1", "]"}], "//", "TableForm"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Export", "[", 
   RowBox[{
    RowBox[{"\"\<Parameters_\>\"", "<>", 
     RowBox[{"ToString", "[", "fn", "]"}], "<>", "\"\<.pdf\>\""}], ",", "P"}],
    "]"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Export", "[", 
    RowBox[{"\"\<Annuli radii.csv\>\"", ",", 
     RowBox[{"N", "[", "X", "]"}], ",", "\"\<CSV\>\""}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"j", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"While", "[", 
    RowBox[{
     RowBox[{"j", "\[LessEqual]", "10"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Export", "[", 
       RowBox[{
        RowBox[{"\"\<fig\>\"", "<>", 
         RowBox[{"ToString", "[", "j", "]"}], "<>", "\"\<.gif\>\""}], ",", 
        RowBox[{"ToExpression", "[", 
         RowBox[{"\"\<fig\>\"", "<>", 
          RowBox[{"ToString", "[", "j", "]"}]}], "]"}], ",", 
        RowBox[{"ImageResolution", "\[Rule]", "300"}]}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"j", "++"}]}]}], "]"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<Ready!\>\"", ",", 
     RowBox[{"FontColor", "\[Rule]", "Red"}], ",", 
     RowBox[{"FontWeight", "\[Rule]", "Bold"}], ",", 
     RowBox[{"FontSize", "\[Rule]", "10"}]}], "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"SystemOpen", "[", "dir1", "]"}], "\[IndentingNewLine]", 
 RowBox[{"FrontEndExecute", "[", 
  RowBox[{"FrontEndToken", "[", "\"\<DeleteGeneratedCells\>\"", "]"}], 
  "]"}]}], "Input",
 Editable->False,
 CellChangeTimes->{
  3.816318975232027*^9, {3.8163190208241043`*^9, 3.8163190390980563`*^9}, {
   3.816319091243685*^9, 3.816319092648758*^9}, 3.816319444227359*^9, {
   3.8163329612469006`*^9, 3.816332961699896*^9}, {3.816333688801203*^9, 
   3.8163336898792562`*^9}, 3.8163340089185667`*^9, {3.8163408149746437`*^9, 
   3.8163408167844257`*^9}, {3.8163409155759945`*^9, 3.816340937274977*^9}, {
   3.8163412723881483`*^9, 3.8163412753324933`*^9}, 3.816341409877613*^9, {
   3.81634153034256*^9, 3.816341573256206*^9}, {3.8163419014359045`*^9, 
   3.8163419277272224`*^9}, {3.816342063693818*^9, 3.8163420663606434`*^9}, {
   3.8163421174764357`*^9, 3.8163421216738815`*^9}, {3.8163460978016567`*^9, 
   3.816346101259487*^9}, 3.8163461321678057`*^9, {3.816348476757405*^9, 
   3.8163485183621902`*^9}, {3.816353846401376*^9, 3.8163538467137594`*^9}, {
   3.8163546288758607`*^9, 3.8163546605253696`*^9}, {3.81635582525873*^9, 
   3.8163558402708235`*^9}, {3.816355915878889*^9, 3.816355961415818*^9}, {
   3.8163561665433054`*^9, 3.816356167168209*^9}, {3.8163563599307823`*^9, 
   3.816356376661959*^9}, 3.8163564076077433`*^9, {3.8163570338625245`*^9, 
   3.816357039361224*^9}, {3.816357080289894*^9, 3.8163571221409883`*^9}, {
   3.8163572103241043`*^9, 3.816357213526511*^9}, {3.816357295257888*^9, 
   3.8163573008675175`*^9}, {3.8164199725453744`*^9, 3.81642000855366*^9}, {
   3.816420145789807*^9, 3.816420159817793*^9}, {3.8164203338734894`*^9, 
   3.8164204048268538`*^9}, {3.816421209487547*^9, 3.8164212218606668`*^9}, {
   3.8164352149402504`*^9, 3.816435258282748*^9}, {3.816436212475564*^9, 
   3.8164362405793257`*^9}, {3.816440899554779*^9, 3.816440905662757*^9}, {
   3.816440940077989*^9, 3.816440978522341*^9}, {3.816590004166379*^9, 
   3.816590013156328*^9}, {3.8165918522086816`*^9, 3.8165918543958254`*^9}, {
   3.816591885944574*^9, 3.8165919276471596`*^9}, {3.8165973288001165`*^9, 
   3.816597342031347*^9}, 3.8165973884286027`*^9, 3.816597631841973*^9, 
   3.816597935391968*^9, {3.8172720478548756`*^9, 3.817272049082343*^9}, {
   3.865042114230857*^9, 3.865042115724044*^9}, 3.8807110091880584`*^9, {
   3.8807118206220045`*^9, 3.880711822655805*^9}, {3.880712184035248*^9, 
   3.880712187135438*^9}, {3.880714889416601*^9, 3.8807149716186085`*^9}, {
   3.880715008735157*^9, 3.8807150115716968`*^9}, {3.880715085090435*^9, 
   3.8807151230259275`*^9}, {3.880716031139336*^9, 3.8807161919093733`*^9}, {
   3.8807162366130176`*^9, 3.8807163529735126`*^9}, {3.8807164261534324`*^9, 
   3.8807164289431515`*^9}, {3.880717066554194*^9, 3.880717067641052*^9}, {
   3.8807171457235527`*^9, 3.880717187151127*^9}, {3.8807172334172506`*^9, 
   3.8807173303081775`*^9}, {3.8807173769610047`*^9, 3.880717439402605*^9}, {
   3.880717483730625*^9, 3.880717623478962*^9}, {3.880724596980039*^9, 
   3.8807247613417854`*^9}, {3.880724996149357*^9, 3.88072502978286*^9}, {
   3.8807284099826126`*^9, 3.8807284125899754`*^9}, {3.880765669994827*^9, 
   3.8807656839797583`*^9}, {3.880768278533481*^9, 3.8807682857212076`*^9}, 
   3.8807687134915433`*^9, {3.8807691608550043`*^9, 3.880769163308489*^9}, {
   3.880769687800776*^9, 3.880769697422462*^9}, 3.8807698731031303`*^9, {
   3.8807700173192883`*^9, 3.8807700280345254`*^9}, 3.880770292943022*^9, {
   3.8807742138623705`*^9, 3.8807742177748084`*^9}, {3.880774256363869*^9, 
   3.8807742839705667`*^9}, {3.8807743249090385`*^9, 3.880774325737403*^9}, {
   3.880774926942417*^9, 3.8807749630561876`*^9}, {3.8807750047965617`*^9, 
   3.8807750986516867`*^9}, {3.8807761500914383`*^9, 
   3.8807761608932476`*^9}, {3.8807762645639734`*^9, 
   3.8807762796465287`*^9}, {3.8807763374475603`*^9, 
   3.8807763606245737`*^9}, {3.8807764170079184`*^9, 3.88077642341483*^9}, {
   3.8807764660669737`*^9, 3.880776507345168*^9}, 3.8807813415305347`*^9, {
   3.8807857421771193`*^9, 3.880785750998131*^9}, {3.8807860279021215`*^9, 
   3.8807860291669908`*^9}, 3.88078660582837*^9, 3.880786655936799*^9, {
   3.8807873199554443`*^9, 3.8807873322933493`*^9}, {3.8807879700229034`*^9, 
   3.880787975366558*^9}, {3.880788007775596*^9, 3.88078800814342*^9}, {
   3.8807881927696457`*^9, 3.8807882034504833`*^9}, {3.8807895245703955`*^9, 
   3.8807895280898924`*^9}, {3.8807896538160944`*^9, 3.880789671988967*^9}, {
   3.880791329960593*^9, 3.8807913336192913`*^9}, {3.880791385652666*^9, 
   3.8807913899413395`*^9}, {3.880791521091098*^9, 3.8807915214160423`*^9}, {
   3.8807918511993523`*^9, 3.880791852178254*^9}, {3.880792926320291*^9, 
   3.8807929504541397`*^9}, {3.8808022595887127`*^9, 
   3.8808022698424034`*^9}, {3.8808087096999197`*^9, 3.880808710125379*^9}, {
   3.880853951484706*^9, 3.880854002600103*^9}, {3.880854630299756*^9, 
   3.8808546933889837`*^9}, {3.8808547779886866`*^9, 
   3.8808547809170055`*^9}, {3.880854817313265*^9, 3.8808548257475767`*^9}, {
   3.880855154969595*^9, 3.880855160583212*^9}, {3.8808552697579613`*^9, 
   3.8808552782854958`*^9}, {3.8808553819553065`*^9, 
   3.8808553873828163`*^9}, {3.8808554257094283`*^9, 3.880855476546082*^9}, {
   3.8808555766242948`*^9, 3.880855614382456*^9}, {3.880855730739332*^9, 
   3.880855760337512*^9}, {3.8808566720477667`*^9, 3.8808566873838615`*^9}, {
   3.8808576253329782`*^9, 3.88085762596214*^9}, {3.8808576674976807`*^9, 
   3.8808576747050138`*^9}, {3.880857722146346*^9, 3.8808577455551186`*^9}, {
   3.880857876974139*^9, 3.8808578890701246`*^9}, {3.8808582661316853`*^9, 
   3.8808583169278564`*^9}, 3.8808615855187836`*^9, {3.8808616331981077`*^9, 
   3.8808616345912447`*^9}, {3.8808629995837064`*^9, 
   3.8808630014651384`*^9}, {3.8808635644561205`*^9, 3.880863572172702*^9}, {
   3.8808638320597467`*^9, 3.880863857219879*^9}, {3.880863889617081*^9, 
   3.8808639052754374`*^9}, {3.8808643723972282`*^9, 3.880864398661354*^9}, 
   3.880864448416664*^9, {3.8808644839267373`*^9, 3.8808644842426257`*^9}, {
   3.8808645431680307`*^9, 3.880864590809645*^9}, {3.8808654648198404`*^9, 
   3.880865470401441*^9}, {3.880866125571566*^9, 3.880866217912265*^9}, {
   3.8808663122692213`*^9, 3.880866313073927*^9}, {3.8808665149164863`*^9, 
   3.8808665300658894`*^9}, {3.880866627691943*^9, 3.8808666718519354`*^9}, 
   3.8808671344438896`*^9, {3.880867367490723*^9, 3.8808673729182253`*^9}, 
   3.880868111574983*^9, 3.88086992219096*^9, {3.8808699752252526`*^9, 
   3.880869985441331*^9}, {3.880870200308948*^9, 3.8808702190585213`*^9}, {
   3.8808711198479085`*^9, 3.8808711382834873`*^9}, 3.8808712216197295`*^9, 
   3.880872436542731*^9, {3.880872797806295*^9, 3.880872942157069*^9}, {
   3.880873081504644*^9, 3.880873084366869*^9}, {3.880881097976023*^9, 
   3.880881098209774*^9}, {3.8808811315497246`*^9, 3.880881134792221*^9}, {
   3.8808812045749645`*^9, 3.8808812048714733`*^9}, {3.88088162199961*^9, 
   3.8808816412539496`*^9}, 3.880895396843867*^9, {3.880895527430995*^9, 
   3.88089554861267*^9}, {3.8808955815667953`*^9, 3.880895625507188*^9}, 
   3.880895659228964*^9, {3.8809694251650734`*^9, 3.8809694394511013`*^9}, {
   3.8809694851031623`*^9, 3.8809694933750534`*^9}, {3.880969664273138*^9, 
   3.8809697162525487`*^9}, {3.8809699730323563`*^9, 
   3.8809700423065753`*^9}, {3.8809718411148243`*^9, 
   3.8809718830655785`*^9}, {3.8809720192036176`*^9, 
   3.8809720549895754`*^9}, {3.880972753254675*^9, 3.8809727673392878`*^9}, {
   3.880972797470959*^9, 3.880972812356145*^9}, {3.880972865888401*^9, 
   3.8809728840713196`*^9}, {3.8809858151049404`*^9, 
   3.8809859712024364`*^9}, {3.880986528792668*^9, 3.8809866065468655`*^9}, {
   3.8809867349814806`*^9, 3.8809867507277746`*^9}, {3.880987047008979*^9, 
   3.8809870664501324`*^9}, {3.8809932473449574`*^9, 3.880993261837331*^9}, {
   3.880993686478145*^9, 3.880993690985565*^9}, {3.8809938093394585`*^9, 
   3.880993872623032*^9}, {3.8809939036152897`*^9, 3.8809939337858534`*^9}, {
   3.8809939727493334`*^9, 3.8809939954713182`*^9}, {3.8809940277245016`*^9, 
   3.880994130769636*^9}, {3.880994171350683*^9, 3.8809942263994775`*^9}, {
   3.881030976629778*^9, 3.8810309817938824`*^9}, {3.881031015310172*^9, 
   3.88103106884942*^9}, {3.8810314176263638`*^9, 3.8810314502342215`*^9}, 
   3.881034665332035*^9, {3.8810350191227217`*^9, 3.88103505372353*^9}, {
   3.881035094538978*^9, 3.8810350948407073`*^9}, {3.8810372281963267`*^9, 
   3.8810372287928557`*^9}, {3.881038874747714*^9, 3.881038876688121*^9}, 
   3.881043481632312*^9, {3.88104358201937*^9, 3.8810435894427133`*^9}, {
   3.881043708239856*^9, 3.8810437372626476`*^9}, {3.8810441834950967`*^9, 
   3.8810441929316196`*^9}, 3.881044350572117*^9, 3.8810448747886267`*^9, {
   3.8810453168824873`*^9, 3.8810453661524997`*^9}, 3.8810455471086087`*^9, {
   3.881046084770545*^9, 3.881046110887724*^9}, {3.881046958249892*^9, 
   3.8810469711305423`*^9}, {3.8810474440755796`*^9, 3.88104745939811*^9}, {
   3.8810475010063114`*^9, 3.881047548189127*^9}, {3.881047658854513*^9, 
   3.881047670201661*^9}, {3.8810485606113124`*^9, 3.881048591354768*^9}, {
   3.8810486389404836`*^9, 3.8810486593635826`*^9}, {3.881048692515144*^9, 
   3.8810486931814156`*^9}, {3.8810497275843973`*^9, 3.881049732345752*^9}, 
   3.8810498381886797`*^9, 3.881049930667957*^9, {3.881049989858902*^9, 
   3.8810500125125465`*^9}, {3.881050139248702*^9, 3.881050185954352*^9}, 
   3.8810506978374386`*^9, {3.8810507527670546`*^9, 3.8810507934192953`*^9}, {
   3.8810512333395367`*^9, 3.8810512456719723`*^9}, 3.881051334496467*^9, 
   3.881051591407592*^9, {3.8810530983936224`*^9, 3.881053214413406*^9}, {
   3.881053247353788*^9, 3.881053289687793*^9}, 3.8811238620583935`*^9, {
   3.8811239023604565`*^9, 3.8811239091210394`*^9}, 3.8811240392255273`*^9, {
   3.881745101027875*^9, 3.881745106077701*^9}, {3.8817452143108*^9, 
   3.881745235578827*^9}, {3.88180124815701*^9, 3.8818012650293407`*^9}, {
   3.8818013268801785`*^9, 3.881801392659054*^9}, {3.88180144797775*^9, 
   3.881801459580164*^9}, {3.881802021585266*^9, 3.8818020309215655`*^9}, {
   3.881802193782159*^9, 3.8818021942107334`*^9}, {3.8818032141319056`*^9, 
   3.8818032312810574`*^9}, 3.881806541059775*^9, {3.881807210128104*^9, 
   3.8818072523700256`*^9}, {3.8818073180121827`*^9, 3.881807332261758*^9}, {
   3.881807428156228*^9, 3.881807555768031*^9}, {3.8818077321679335`*^9, 
   3.8818077558854017`*^9}, {3.881807792849527*^9, 3.881807798577718*^9}, 
   3.8818078739858055`*^9, {3.881808033732227*^9, 3.881808046156578*^9}, {
   3.881808088833124*^9, 3.8818080931813354`*^9}, {3.8818083604872365`*^9, 
   3.881808367128857*^9}, {3.8818090400806623`*^9, 3.8818090806321487`*^9}, 
   3.8818092024953856`*^9, {3.8818092770599575`*^9, 3.88180930874205*^9}, {
   3.8818096256939297`*^9, 3.881809626233677*^9}, {3.881810591855882*^9, 
   3.8818105919905066`*^9}, 3.881812196612143*^9, {3.8818122631940255`*^9, 
   3.881812295060486*^9}, 3.881813031734795*^9, 3.8818132296162124`*^9, {
   3.8818160721329737`*^9, 3.88181608802594*^9}, {3.8818163957831526`*^9, 
   3.8818163968181577`*^9}, {3.8818165635123234`*^9, 3.881816568718115*^9}, {
   3.8818233331004353`*^9, 3.881823347351074*^9}, {3.881823404036602*^9, 
   3.8818234044103837`*^9}, {3.8819827458544903`*^9, 3.881982754052594*^9}},
 FontWeight->"Plain",
 Background->GrayLevel[
  0.85],ExpressionUUID->"76a370bc-cec2-43a9-970f-6627cfa154c9"]
}, Open  ]]
},
WindowSize->{1428., 743.25},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification:>1. Inherited,
FrontEndVersion->"13.0 for Microsoft Windows (64-bit) (December 2, 2021)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"24db3f38-81a4-4f76-aa9d-c56790105d65"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 3915, 61, 256, "Title",ExpressionUUID->"92af6e7b-8264-4e2a-935f-b6903976d59f"],
Cell[4498, 85, 121186, 3069, 11429, "Input",ExpressionUUID->"76a370bc-cec2-43a9-970f-6627cfa154c9"]
}, Open  ]]
}
]
*)

