# -*- coding: utf-8 -*-
"""
Created on Tue Aug  9 13:47:02 2022

@author: Edoardo
"""

from algorithms.fastlin.src.bounds import BoundedLayer

"""
Class that holds the parameters of a compressed neural network
"""
class FastLinNet():
    
    """
    Pass list of weights and biases, plus bounds on the network input
    """
    def __init__(self, WeightMatrixList, BiasVectorList, InputMax, InputMin):
        
        assert len(WeightMatrixList) == len(BiasVectorList)
        
        self.layers = [None] * len(WeightMatrixList)
        
        # initialise all layers
        for i in range(0, len(WeightMatrixList)):
            
            self.layers[i] = BoundedLayer(WeightMatrixList[i],
                                          BiasVectorList[i],
                                          InputMax,
                                          InputMin)
            
            InputMax, InputMin = self.layers[i].OutputBounds()
        
    """
    Execute the whole compressed network
    """
    def Execute(self, UpperInput, LowerInput):
        
        LayerOutput = [None] * (len(self.layers) + 1)
        LayerOutput[0] = (UpperInput, LowerInput)
        
        for i in range(len(self.layers) - 1):
            LayerOutput[i + 1] = self.layers[i].Execute(*LayerOutput[i], WithReLU=True)
        
        LayerOutput[-1] = self.layers[-1].Execute(*LayerOutput[-2], WithReLU=False)
        
        return LayerOutput
    