## Overview of transit occupancy - pandemic project output data repository
for "Combined Effect of Changes in Transit Service and Changes in Occupancy on Per-Passenger Energy Consumption"; Published paper can be accessed at: https://journals.sagepub.com/doi/abs/10.1177/03611981221111160
#### Huiying ("Fizzy") Fan, Georgia Institute of Technology, fizzyfan@gatech.edu
#### Oct. 2022

***

This README file is to provide an overview for files in the data repository of "Combined Effect of Changes in Transit Service and Changes in Occupancy on Per-Passenger Energy Consumption". 

**emPol.csv**
* Contains a summary of emission/energy use by year and emission type
* Columns should be self-explanatory, percent indicates percentage compared to 2019 level 

**emSumm[year].csv**
* Three related files: emSumm19.csv; emSumm20.csv; and emSumm21.csv
* Contains a summary of energy use and trip information by year 
* Columns:
	* pollutantID: pollutant ID in MOVES format
	* emQuan: total amount of energy use in (using the default unit given by MOVES)
	* passMi: total passenger miles traveled on route over the one-week study period
	* emPerPM: emission/energy use per passenger mile
	* polName: pollutant name

**emDay[year].csv**
* Three related files:emDay19.csv; emDay20.csv; and emDay21.csv
* Contains a summary of energy use and trip information in each day by year 
* Columns:
	* CALENDAR_ID: date code
	* pollutantID: pollutant ID in MOVES format
	* emQuan: total amount of energy use in (using the default unit given by MOVES)
	* passMi: total passenger miles traveled on route over the one-week study period
	* emPerPM: emission/energy use per passenger mile
	* polName: pollutant name

**emRoute[year].csv**
* Three related files: emRoute19.csv; emRoute20.csv; and emRoute21.csv
* Contains emission and energy use for each year
* Columns: 
	* route_name: route name, as specified in the GTFS file
	* pollutantID: pollutant ID in MOVES format
	* emQuan: total amount of energy use in (using the default unit given by MOVES)
	* passMi: total passenger miles traveled on route over the one-week study period
	* emPerPM: emission/energy use per passenger mile
	* polName: pollutant name

**emLink[year].shp**
* Three related shapefiles (including a variety of file extentions): emLink19.shp; emLink20.shp; and emLink20.shp
* Contains energy use information for each year
* Columns: 
	* trip_id: trip ID, as specified in the GTFS file
	* link_id: "[starting_stop_id]_[ending_stop_id]", stop ID as specified in the GTFS file
	* shape_d: shape ID, as specified in the GTFS file
	* length: length of the link, feet
	* dist: total distance traveled in link, mile
	* stop_sq: stop sequence
	* mnPassLd: average passenger load
	* avgSpd: average speed (mph)
	* numTrip: total number of trips
	* emTot: total energy use associated with the link (btu)
	* emPrPsM: energy use per passenger mile
	* emPrPss: energy use per passenger

