% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_epinow.R
\name{run_region}
\alias{run_region}
\title{Run epinow with Regional Processing Code}
\usage{
run_region(
  target_region,
  generation_time,
  delays,
  truncation,
  rt,
  backcalc,
  gp,
  obs,
  stan,
  horizon,
  CrIs,
  reported_cases,
  target_folder,
  target_date,
  return_output,
  output,
  complete_logger,
  verbose,
  progress_fn,
  ...
)
}
\arguments{
\item{target_region}{Character string indicating the region being evaluated}

\item{generation_time}{A list containing the mean, standard deviation of the
mean (mean_sd), standard deviation (sd), standard deviation of the standard
deviation and the maximum allowed value for the generation time (assuming a
gamma distribution).}

\item{delays}{A call to \code{delay_opts()} defining delay distributions and
options. See the documentation of \code{delay_opts()} and the examples below for
details.}

\item{truncation}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} A list of options as generated by \code{trunc_opts()}
defining the truncation of observed data. Defaults to \code{trunc_opts()}. See \code{estimate_truncation()}
for an approach to estimating truncation from data.}

\item{rt}{A list of options as generated by \code{rt_opts()} defining Rt estimation.
Defaults to \code{rt_opts()}. Set to \code{NULL} to switch to using  back calculation
rather than generating infections using Rt.}

\item{backcalc}{A list of options as generated by \code{backcalc_opts()} to define the
back calculation. Defaults to \code{backcalc_opts()}.}

\item{gp}{A list of options as generated by \code{gp_opts()} to define the
Gaussian process. Defaults to \code{gp_opts()}.Set to NULL to disable the
Gaussian process.}

\item{obs}{A list of options as generated by \code{obs_opts()} defining the
observation model. Defaults to \code{obs_opts()}.}

\item{stan}{A list of stan options as generated by \code{stan_opts()}. Defaults to \code{stan_opts()}. Can be used to override
\code{data}, \code{init}, and \code{verbose} settings if desired.}

\item{horizon}{Numeric, defaults to 7. Number of days into the future to
forecast.}

\item{CrIs}{Numeric vector of credible intervals to calculate.}

\item{reported_cases}{A data frame of confirmed cases (confirm) by date (date), and region (\code{region}).}

\item{target_folder}{Character string specifying where to save results (will create if not present).}

\item{target_date}{Date, defaults to maximum found in the data if not specified.}

\item{return_output}{Logical, defaults to FALSE. Should output be returned, this automatically updates to TRUE
if no directory for saving is specified.}

\item{output}{A character vector of optional output to return. Supported options are the individual regional estimates
("regions"),  samples ("samples"), plots ("plots"), copying the individual region dated folder into
a latest folder (if \code{target_folder} is not null, set using "latest"), the stan fit of the underlying model ("fit"), and an
overall summary across regions ("summary"). The default is to return samples and plots alongside summarised estimates and
summary statistics. If \code{target_folder} is not NULL then the default is also to copy all results into a latest folder.}

\item{complete_logger}{Character string indicating the logger to output
the completion of estimation to.}

\item{verbose}{Logical defaults to FALSE. Outputs verbose progress messages to the console from \code{epinow}.}

\item{progress_fn}{Function as returned by \code{progressr::progressor}. Allows the use of a
progress bar.}

\item{...}{Pass additional arguments to \code{epinow}. See the documentation for \code{epinow} for details.}
}
\value{
A list of processed output as produced by \code{process_region}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}
Internal function that handles calling \code{epinow}. Future work will extend this
function to better handle \code{stan} logs and allow the user to modify settings between
regions.
}
\seealso{
regional_epinow
}
