#Load packages and data ------------------
library(ggplot2)
library(dplyr)
library(dplyr)
library(plyr)
library(reshape)
library(emmeans)
library(multcomp)
library(ggpubr)
library(stringr)

#import VOCs
tab<-read.csv(file="VOC.csv", sep=",", na.strings = "NA", stringsAsFactors=FALSE)
names(tab)
tab$Treatment<- as.factor(tab$Treatment)

names(tab)[2:10] <- c("(Z)-3-hexenyl acetate", 
                      "6-methyl-5-hepten-2-one", 
                      "(Z)-3-hexen-1-ol", 
                      "(E)-ocimene",
                      "linalool",
                      "(E)-DMNT",
                      "methylsalicilate",
                      "(E)-β-caryophyllene",
                      "(E)-β-farnesene")

#rehape tab matrix
mvocs <- melt(tab, id=c("Treatment")) 
names(mvocs)[2:3]<- c("VOCs", "Amount")
mvocs$VOCs<-as.factor(mvocs$VOCs)
mvocs$Treatment<-as.factor(mvocs$Treatment)

#Split major VOCS
major<-filter(mvocs, VOCs %in%  c("(Z)-3-hexenyl acetate", "6-methyl-5-hepten-2-one", "(Z)-3-hexen-1-ol", "linalool"))
major$VOCs<-droplevels(major$VOCs)

#stats
hist(major$Amount) #using quasipoisson distribution

#figure preparation
datmaj<-ddply(major, c("Treatment", "VOCs"), summarise,
              mean = mean(Amount), sd = sd(Amount),
              sem = sd(Amount)/sqrt(length(Amount)))


#with letters above bars
majorlist<-  split(major, f = major$VOCs)                     # Split data
majormat<-matrix(nrow = 3, ncol = length(levels(major$VOCs))+1 )
vocs<-levels(major$VOCs)
colnames(majormat)<- c("Treatment", vocs)
majormat[,1]<- c("Control", "D-DOPA", "L-DOPA")
majormat[1,-1] <- "a"

for (i in 1:length(majorlist)){
  fit<-glm(log(Amount+1)~Treatment, data = majorlist[[i]], family = quasipoisson())
  marginal = emmeans(fit,specs = trt.vs.ctrl ~ Treatment)
  lett<-cld(marginal$contrasts, Letters=letters, alpha = 0.05)
  majormat[2:3,i+1]<-lett$.group
}

majormat<-as.data.frame(majormat)
mmaj <- melt(majormat, id=c("Treatment"))
colnames(mmaj) <- c("Treatment","VOCs","Letters")
mmaj$Letters <- str_replace_all(string=mmaj$Letters, pattern=" ", repl="")


figa_data <- left_join(datmaj,mmaj,by=c("Treatment","VOCs"))
pmaj <-ggplot(figa_data,aes(x=VOCs, y=mean, fill=Treatment, label=Letters)) + 
  geom_bar(stat="identity",position=position_dodge(0.9))+
  geom_text(stat="identity", position = position_dodge(0.9), vjust=-1, aes(y=mean+sem, x=VOCs))+
  coord_cartesian(ylim=c(0,650))+
  geom_errorbar(aes(ymin=mean-sem, ymax=mean+sem),
                width=.2,                   
                position=position_dodge(0.9))+
  xlab("VOCs") +
  ylab("Amount (ng)") +
  labs(fill="Treatment")+
  theme_grey() +
  scale_fill_manual(values=c("#b2914a", "#bc6968", "#6c8262"))

## Split vocs minor
minor<-filter(mvocs, VOCs %in%  c("(E)-ocimene", "(E)-DMNT", "methylsalicilate", "(E)-β-caryophyllene", "(E)-β-farnesene"))
minor$VOCs<-droplevels(minor$VOCs)

#stats
hist(log(minor$Amount+1))

datamin<-ddply(minor, c("Treatment", "VOCs"), summarise,
               mean = mean(Amount), sd = sd(Amount),
               sem = sd(Amount)/sqrt(length(Amount)))

minorlist<-  split(minor, f = minor$VOCs)                     # Split data
minormat<-matrix(nrow = 3, ncol = length(levels(minor$VOCs))+1 )

vocs<-levels(minor$VOCs)
colnames(minormat)<- c("Treatment", vocs)
minormat[,1]<- c("Control", "D-DOPA", "L-DOPA")
minormat[1,-1] <- "a"

for (i in 1:length(minorlist)){
  fit<-glm(log(Amount+1)~Treatment, data = minorlist[[i]], family = quasipoisson())
  marginal = emmeans(fit,specs = trt.vs.ctrl ~ Treatment)
  lett<-cld(marginal$contrasts, Letters=letters, alpha = 0.05)
  minormat[2:3,i+1]<-lett$.group
}

minormat<-as.data.frame(minormat)
mmin <- melt(minormat, id=c("Treatment")) 
colnames(mmin) <- c("Treatment","VOCs","Letters")
mmin$Letters <- str_replace_all(string=mmin$Letters, pattern=" ", repl="")



figb_data <- left_join(datamin,mmin,by=c("Treatment","VOCs"))
pmin <- ggplot(figb_data,aes(x=VOCs, y=mean, fill=Treatment, label=Letters)) + 
  geom_bar(stat="identity",position=position_dodge(0.9))+
  geom_text(stat="identity", position = position_dodge(0.9), vjust=-1, aes(y=mean+sem, x=VOCs))+
  coord_cartesian(ylim=c(0,40))+
  geom_errorbar(aes(ymin=mean-sem, ymax=mean+sem),
                width=.2,                   
                position=position_dodge(0.9))+
  xlab("VOCs") +
  ylab("Amount (ng)") +
  labs(fill="Treatment")+
  theme_grey() +
  scale_fill_manual(values=c("#b2914a", "#bc6968", "#6c8262")) 
  

# Assemble Figure 3
ggarrange(pmaj, pmin,
           labels = c("A", "B"),
           ncol = 1, nrow = 2, common.legend = T)

ggsave("figure3.svg", plot = last_plot(), device = "svg", units = "mm", width = 173, dpi = 600)


