#Load packages--------------
library(ggplot2)
library(MASS)
library(ggpubr)

tab<-read.csv(file="VOC.csv", sep=",", na.strings = "NA", stringsAsFactors=FALSE)
names(tab)
tab$Treatment<- as.factor(tab$Treatment)

###remane VOCcs
names(tab)[2:10] <- c("(Z)-3-hexenyl acetate", 
                      "6-methyl-5-hepten-2-one", 
                      "(Z)-3-hexen-1-ol", 
                      "(E)-ocimene",
                      "linalool",
                      "(E)-DMNT",
                      "methylsalicilate",
                      "(E)-β-caryophyllene",
                      "(E)-β-farnesene")
###LDA
my.lda <-lda(tab[,c(2:10)],tab$Treatment)
vocsproj <- cbind(scale(as.matrix(tab[,c(2:10)]),scale=FALSE) %*% my.lda$scaling,tab[,1,drop=FALSE])
prop= my.lda$svd^2/sum(my.lda$svd^2)
plda <- predict(object = my.lda,   newdata = as.matrix(tab[,c(2:10)]))

Treatment<-as.factor(tab$Treatment)
dataset = data.frame(species = tab$Treatment, lda = plda$x, Treatment)


a <- ggplot(data=dataset,aes(x=lda.LD1,y=lda.LD2,col=Treatment))+ 
  geom_point(size = 3) +
  xlab(paste0("LDA1 (", signif(prop[1], 2)*100, "%)")) + 
  ylab(paste0("LDA2 (", signif(prop[2], 2)*100, "%)"))+ 
  scale_color_manual(values=c("#b2914a", "#bc6968", "#6c8262"))+
  theme_grey()+
  theme(legend.position = "top")

b <-ggplot(dataset,aes(x=lda.LD1,  fill=Treatment))+
  geom_histogram(binwidth = 0.1, alpha = 0.3)+
  geom_density(aes(y=0.5* ..count..),  alpha=0.4)+
    xlab(paste0("LDA1 (", signif(prop[1], 2)*100, "%)")) +
  ylab("Probability density")+ 
  labs(fill = "Treatment")+
  scale_fill_manual(values=c("#b2914a", "#bc6968", "#6c8262") )+
  theme_grey()

data2<-as.data.frame(my.lda$scaling[,1])
data2$group<-rownames(data2)
names(data2)<-c("Change","Factor")

c <- ggplot(data2, 
           aes(x = reorder(Factor,  Change, FUN = mean),
               y = Change, 
               fill = Change < 0)) + 
  geom_bar(stat = "identity") + 
  scale_fill_manual(guide = "none",  values = c( "grey50","grey70"))+
  coord_flip()+ xlab("VOCs")+ylab("Factor scaling LDA1")+
  theme_classic()+
  theme(axis.line=element_blank(),
        panel.grid.major.y = element_line(linetype = "dashed"))

ggarrange(a,                                                 # First row with scatter plot
          ggarrange(b, c, ncol = 2, labels = c("B", "C")), # Second row with box and dot plots
          nrow = 2, 
          labels = "A")                                     # Labels of the scatter plot) 

ggsave("Figure2.svg", device="svg", last_plot(), width = 173, units="mm", dpi = 600)


